/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.graph;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import mekanism.api.math.MathUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.graph.GuiGraph;
import net.minecraft.network.chat.Component;

public class GuiLongGraph
extends GuiGraph<LongList, LongGraphDataHandler> {
    private long currentScale = 10L;

    public GuiLongGraph(IGuiWrapper gui, int x, int y, int width, int height, LongGraphDataHandler handler) {
        super(gui, x, y, width, height, new LongArrayList(), handler);
    }

    public void enableFixedScale(long scale) {
        this.fixedScale = true;
        this.currentScale = scale;
    }

    public void setMinScale(long minScale) {
        this.currentScale = minScale;
    }

    public void addData(long data) {
        if (((LongList)this.graphData).size() == this.f_93618_ - 2) {
            ((LongList)this.graphData).removeLong(0);
        }
        ((LongList)this.graphData).add(data);
        if (!this.fixedScale) {
            LongListIterator longListIterator = ((LongList)this.graphData).iterator();
            while (longListIterator.hasNext()) {
                long i = (Long)longListIterator.next();
                if (i <= this.currentScale) continue;
                this.currentScale = i;
            }
        }
    }

    @Override
    protected int getRelativeHeight(int index, int height) {
        long data = Math.min(this.currentScale, ((LongList)this.graphData).getLong(index));
        return MathUtils.clampToInt((double)(data * (long)height) / (double)this.currentScale);
    }

    @Override
    protected Component getDataDisplay(int hoverIndex) {
        return ((LongGraphDataHandler)this.dataHandler).getDataDisplay(((LongList)this.graphData).getLong(hoverIndex));
    }

    @Override
    public boolean hasPersistentData() {
        return true;
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        LongListIterator longListIterator = ((LongList)((GuiLongGraph)element).graphData).iterator();
        while (longListIterator.hasNext()) {
            long data = (Long)longListIterator.next();
            this.addData(data);
        }
    }

    public static interface LongGraphDataHandler
    extends GuiGraph.GraphDataHandler {
        public Component getDataDisplay(long var1);
    }
}

