/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.struct.stash;

import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.util.struct.Structs;
import pro.komaru.tridot.util.struct.data.Seq;
import pro.komaru.tridot.util.struct.stash.SyncStashObject;
import pro.komaru.tridot.util.struct.stash.net.SyncStashObjectPacket;

public class SyncStash {
    private static int lastId = 0;
    private static final Seq<SyncStashObject<?>> stash = Seq.with();
    private static final Seq<Integer> lastChanged = Seq.with();

    public static <T> int add(T obj) {
        SyncStashObject<T> stashObject = new SyncStashObject<T>(obj);
        stash.setSize(Math.max(SyncStash.stash.size, stashObject.getId() + 1));
        stash.set(stashObject.getId(), stashObject);
        lastChanged.addUnique(stashObject.getId());
        return stashObject.getId();
    }

    public static <T> int set(int id, byte[] obj) {
        SyncStashObject stashObject = new SyncStashObject(id, obj);
        stash.setSize(Math.max(SyncStash.stash.size, stashObject.getId() + 1));
        stash.set(stashObject.getId(), stashObject);
        return stashObject.getId();
    }

    public static <T> int setAt(int id, T obj) {
        boolean same = stash.getOrNull(id) == obj;
        SyncStashObject<T> stashObject = new SyncStashObject<T>(obj);
        stashObject.setId(id);
        stash.setSize(Math.max(SyncStash.stash.size, stashObject.getId() + 1));
        stash.set(stashObject.getId(), stashObject);
        if (!same) {
            lastChanged.addUnique(stashObject.getId());
        }
        return stashObject.getId();
    }

    public static <T> T get(int obj) {
        return (T)Structs.safeGet(SyncStash.getStash().getOrNull(obj), a -> a.get());
    }

    public static <T> T getAndDelete(int obj) {
        T stashObject = SyncStash.get(obj);
        lastChanged.addUnique(SyncStash.getStash().get(obj).getId());
        stash.remove(obj);
        if (lastId == obj) {
            --lastId;
        }
        return stashObject;
    }

    public static void notify(int id) {
        lastChanged.addUnique(id);
    }

    public static void synchronizeLast(SimpleChannel CHANNEL) {
        for (Integer i : lastChanged) {
            SyncStashObject<?> toSync = stash.get(i);
            int id = toSync.getId();
            byte[] bytes = toSync.toBytes();
            for (ServerPlayer player : Utils.players()) {
                CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncStashObjectPacket(id, bytes));
            }
        }
    }

    public static int nextId() {
        return lastId++;
    }

    public static Seq<SyncStashObject<?>> getStash() {
        return stash;
    }
}

