/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import pro.komaru.tridot.util.file.FilePredicate;
import pro.komaru.tridot.util.file.parsers.Jsonf;
import pro.komaru.tridot.util.file.parsers.Yamlf;
import pro.komaru.tridot.util.struct.data.Pair;
import pro.komaru.tridot.util.struct.data.Seq;
import pro.komaru.tridot.util.struct.func.Cons2;

public class Files {
    public static <T> T parse(Class<T> clazz, byte[] body, String ext) {
        return Files.parse(clazz, new String(body, StandardCharsets.UTF_8), ext);
    }

    public static <T> T parse(Class<T> clazz, String body, String ext) {
        return (T)(switch (ext) {
            case "json", "j" -> Jsonf.gson.fromJson(body, clazz);
            case "yaml", "yml", "y" -> Yamlf.yamlToJava(body, clazz);
            default -> null;
        });
    }

    public static <T> T parseList(Class<T> clazz, String body, String ext) {
        return (T)(switch (ext) {
            case "json", "j" -> Jsonf.gson.fromJson(body, clazz);
            case "yaml", "yml", "y" -> Yamlf.yamlListToJava(body, clazz);
            default -> null;
        });
    }

    public static void filesDeep(File dir, Cons2<Pair<File, String>, Pair<String, String>> consumer) {
        Seq<File> seq = Files.filesDeep(dir);
        FilePredicate predicate = FilePredicate.ofStatic(dir);
        seq.each(f -> consumer.get(new Pair<File, String>((File)f, Files.read(f)), Files.idExt(predicate, f)));
    }

    public static void filesDeepf(File dir, Cons2<File, Pair<String, String>> consumer) {
        Seq<File> seq = Files.filesDeep(dir);
        FilePredicate predicate = FilePredicate.ofStatic(dir);
        seq.each(f -> consumer.get((File)f, Files.idExt(predicate, f)));
    }

    public static InputStreamReader input(File f) throws FileNotFoundException {
        return new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);
    }

    public static OutputStreamWriter output(File f) throws FileNotFoundException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);
    }

    public static FileInputStream inputStream(File f) throws FileNotFoundException {
        return new FileInputStream(f);
    }

    public static FileOutputStream outputStream(File f) throws FileNotFoundException {
        return new FileOutputStream(f);
    }

    public static String id(FilePredicate rootPredicate, File file) {
        String path = file.getAbsolutePath();
        String id = path.substring(rootPredicate.get().getAbsolutePath().length() + 1).replace("\\", "/");
        id = Files.removeExtension(id);
        return id;
    }

    public static Pair<String, String> idExt(FilePredicate rootPredicate, File file) {
        return new Pair<String, String>(Files.id(rootPredicate, file), Files.ext(file.getName()));
    }

    public static String removeExtension(String name) {
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex != -1) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    public static String ext(String name) {
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex != -1) {
            return name.substring(dotIndex + 1);
        }
        return "";
    }

    public static Seq<File> filesDeep(File dir) {
        File[] files = dir.listFiles();
        Seq<File> fileList = Seq.with();
        for (File file : files) {
            if (file.isDirectory()) {
                fileList.addAll(Files.filesDeep(file));
                continue;
            }
            fileList.add(file);
        }
        return fileList;
    }

    public static Seq<File> dirs(File dir) {
        File[] dirs = dir.listFiles(File::isDirectory);
        Seq<File> dirList = Seq.with();
        for (File file : dirs) {
            dirList.add(file);
        }
        return dirList;
    }

    public static String read(File f) {
        try {
            int t;
            InputStreamReader reader = Files.input(f);
            StringBuilder readResult = new StringBuilder();
            while ((t = reader.read()) != -1) {
                readResult.append((char)t);
            }
            return readResult.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(File f) {
        try (FileInputStream stream = Files.inputStream(f);){
            byte[] byArray;
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] chunk = new byte[8192];
                while ((bytesRead = ((InputStream)stream).read(chunk)) != -1) {
                    buffer.write(chunk, 0, bytesRead);
                }
                byArray = buffer.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430: " + f.getName(), e);
        }
    }

    public static void write(File f, String str) {
        try {
            OutputStreamWriter writer = Files.output(f);
            writer.write(str);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void write(File f, byte[] bytes) {
        try {
            FileOutputStream outputStream = new FileOutputStream(f);
            ((OutputStream)outputStream).write(bytes);
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

