/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import pro.komaru.tridot.util.struct.data.Seq;

public class Reflect {
    public static Seq<Class<?>> findClasses(String packageName, String simpleClassName) throws ClassNotFoundException, IOException {
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources(path);
        Seq<Class<?>> matchingClasses = Seq.with();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String protocol = resource.getProtocol();
            if ("file".equals(protocol)) {
                File directory = new File(resource.getFile());
                matchingClasses.addAll(Reflect.findClassesInDirectory(directory, packageName, simpleClassName));
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            String jarPath = resource.getPath().substring(5, resource.getPath().indexOf("!"));
            matchingClasses.addAll(Reflect.findClassesInJar(jarPath, packageName, simpleClassName));
        }
        return matchingClasses;
    }

    private static Seq<Class<?>> findClassesInDirectory(File directory, String packageName, String simpleClassName) throws ClassNotFoundException {
        Seq<Class<?>> classes = Seq.with();
        if (directory.exists()) {
            for (File file : directory.listFiles()) {
                String className;
                Class<?> clazz;
                if (file.isDirectory()) {
                    classes.addAll(Reflect.findClassesInDirectory(file, packageName + "." + file.getName(), simpleClassName));
                    continue;
                }
                if (!file.getName().endsWith(".class") || !(clazz = Class.forName(className = packageName + "." + file.getName().replace(".class", ""))).getSimpleName().equals(simpleClassName)) continue;
                classes.add(clazz);
            }
        }
        return classes;
    }

    private static Seq<Class<?>> findClassesInJar(String jarPath, String packageName, String simpleClassName) throws ClassNotFoundException, IOException {
        Seq<Class<?>> classes = Seq.with();
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            String path = packageName.replace('.', '/');
            while (entries.hasMoreElements()) {
                String className;
                Class<?> clazz;
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(path) || !entry.getName().endsWith(".class") || !(clazz = Class.forName(className = entry.getName().replace('/', '.').replace(".class", ""))).getSimpleName().equals(simpleClassName)) continue;
                classes.add(clazz);
            }
        }
        return classes;
    }
}

