/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.types;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public class HitEffectItem
extends SwordItem {
    public float chance = 1.0f;
    public final ImmutableList<MobEffectInstance> effects;
    public ArcRandom arcRandom = Tmp.rnd;

    public HitEffectItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn, float pChance, MobEffectInstance ... pEffects) {
        super(tier, (int)attackDamageIn, attackSpeedIn, builderIn);
        this.chance = pChance;
        this.effects = ImmutableList.copyOf((Object[])pEffects);
    }

    public HitEffectItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn, MobEffectInstance ... pEffects) {
        super(tier, (int)attackDamageIn, attackSpeedIn, builderIn);
        this.effects = ImmutableList.copyOf((Object[])pEffects);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!(attacker instanceof Player)) {
            return true;
        }
        Player player = (Player)attacker;
        stack.m_41622_(2, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        if (Utils.Items.getAttackStrengthScale(player, 0.9f)) {
            Utils.Entities.applyWithChance(target, this.effects, this.chance, this.arcRandom);
        }
        return true;
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        Utils.Items.effectTooltip(this.effects, tooltip, 1.0f, this.chance);
    }
}

