/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.armor;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.extensions.IForgeItem;
import pro.komaru.tridot.client.model.armor.ArmorModel;
import pro.komaru.tridot.common.registry.item.armor.PercentageArmorItem;
import pro.komaru.tridot.common.registry.item.skins.ItemSkin;

public class SkinableArmorItem
extends PercentageArmorItem
implements IForgeItem {
    public SkinableArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ItemSkin skin = ItemSkin.itemSkin(stack);
        if (skin == null) {
            return super.getArmorTexture(stack, entity, slot, type);
        }
        return skin.getArmorTexture(stack, entity, slot, type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel original) {
                ArmorModel model = SkinableArmorItem.this.getArmorModel(entity, itemStack, armorSlot, original);
                if (model != null) {
                    return model;
                }
                return original;
            }
        });
    }

    public ArmorModel getArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> original) {
        float partialTicks = Minecraft.m_91087_().m_91296_();
        float f = Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)entity.f_20886_, (float)entity.f_20885_);
        float netHeadYaw = f1 - f;
        float netHeadPitch = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        ItemSkin skin = ItemSkin.itemSkin(itemStack);
        if (skin != null) {
            ArmorModel model = skin.getArmorModel(entity, itemStack, armorSlot, original);
            model.slot = this.f_265916_.m_266308_();
            model.copyFromDefault(original);
            model.m_6973_(entity, entity.f_267362_.m_267590_(partialTicks), entity.f_267362_.m_267711_(partialTicks), (float)entity.f_19797_ + partialTicks, netHeadYaw, netHeadPitch);
            return model;
        }
        return null;
    }
}

