/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.armor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.common.config.CommonConfig;
import pro.komaru.tridot.common.registry.item.AttributeRegistry;
import pro.komaru.tridot.common.registry.item.armor.TridotArmorMat;
import pro.komaru.tridot.common.registry.item.builders.AbstractArmorBuilder;

public class PercentageArmorItem
extends ArmorItem {
    public ArmorMaterial material;
    public UUID uuid;
    private final float defense;
    private final float toughness;
    protected final float knockbackResistance;
    public static final EnumMap<ArmorItem.Type, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266744_ -> {
        p_266744_.put(ArmorItem.Type.BOOTS, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        p_266744_.put(ArmorItem.Type.LEGGINGS, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        p_266744_.put(ArmorItem.Type.CHESTPLATE, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        p_266744_.put(ArmorItem.Type.HELMET, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    public final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.##"), p_41704_ -> p_41704_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public Multimap<Attribute, AttributeModifier> defaultModifiers;

    public PercentageArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
        this.material = pMaterial;
        this.toughness = pMaterial.m_6651_();
        if (pMaterial instanceof TridotArmorMat) {
            TridotArmorMat mat = (TridotArmorMat)pMaterial;
            this.defense = mat.getPercentDefenseForType(pType);
        } else {
            this.defense = pMaterial.m_7366_(pType);
        }
        this.knockbackResistance = pMaterial.m_6649_();
        this.uuid = ARMOR_MODIFIER_UUID_PER_TYPE.get(pType);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (this.knockbackResistance > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(this.uuid, "Armor knockback resistance", (double)this.knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        builder.put((Object)((Attribute)AttributeRegistry.PERCENT_ARMOR.get()), (Object)new AttributeModifier(this.uuid, "PercentArmor", (double)this.defense, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(this.uuid, "Armor toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public int m_40404_() {
        return Math.round(this.defense);
    }

    public float m_40405_() {
        return this.toughness;
    }

    public float getTotalDefense(ArmorMaterial material) {
        if (material instanceof TridotArmorMat) {
            TridotArmorMat tridotArmorMat = (TridotArmorMat)material;
            return tridotArmorMat.getPercentDefenseForType(ArmorItem.Type.HELMET) + tridotArmorMat.getPercentDefenseForType(ArmorItem.Type.CHESTPLATE) + tridotArmorMat.getPercentDefenseForType(ArmorItem.Type.LEGGINGS) + tridotArmorMat.getPercentDefenseForType(ArmorItem.Type.BOOTS);
        }
        return material.m_7366_(ArmorItem.Type.HELMET) + material.m_7366_(ArmorItem.Type.CHESTPLATE) + material.m_7366_(ArmorItem.Type.LEGGINGS) + material.m_7366_(ArmorItem.Type.BOOTS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (CommonConfig.PERCENT_ARMOR.get() != null && ((Boolean)CommonConfig.PERCENT_ARMOR.get()).booleanValue()) {
            pStack.m_41654_(ItemStack.TooltipPart.MODIFIERS);
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.tridot.total_armor", (Object[])new Object[]{this.getTotalDefense(((PercentageArmorItem)pStack.m_41720_()).m_40401_()) + "%"}).m_130940_(ChatFormatting.GRAY));
            LocalPlayer pPlayer = Minecraft.m_91087_().f_91074_;
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                Multimap multimap = this.getAttributeModifiers(equipmentslot, pStack);
                if (multimap.isEmpty()) continue;
                pTooltipComponents.add(CommonComponents.f_237098_);
                pTooltipComponents.add((Component)Component.m_237115_((String)("item.modifiers." + equipmentslot.m_20751_())).m_130940_(ChatFormatting.GRAY));
                for (Map.Entry entry : multimap.entries()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    double d0 = attributemodifier.m_22218_();
                    boolean flag = false;
                    if (pPlayer != null) {
                        if (attributemodifier.m_22209_() == Item.f_41374_) {
                            d0 += pPlayer.m_21172_(Attributes.f_22281_);
                            d0 += (double)EnchantmentHelper.m_44833_((ItemStack)pStack, (MobType)MobType.f_21640_);
                            flag = true;
                        } else if (attributemodifier.m_22209_() == Item.f_41375_) {
                            d0 += pPlayer.m_21172_(Attributes.f_22283_);
                            flag = true;
                        }
                    }
                    double d1 = attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? d0 * 100.0 : d0) : d0 * 100.0;
                    if (flag) {
                        pTooltipComponents.add((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{this.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN));
                        continue;
                    }
                    if (d0 > 0.0) {
                        pTooltipComponents.add((Component)Component.m_237110_((String)"attribute.modifier.plus.1", (Object[])new Object[]{this.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    pTooltipComponents.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{this.ATTRIBUTE_MODIFIER_FORMAT.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    public float attrDist(AbstractArmorBuilder<?> builder, EquipmentSlot pEquipmentSlot, float percent) {
        float head = percent * builder.headAtrPercent / 100.0f;
        float chest = percent * builder.chestAtrPercent / 100.0f;
        float leggings = percent * builder.leggingsAtrPercent / 100.0f;
        float boots = percent * builder.bootsAtrPercent / 100.0f;
        float remainder = percent - (head + chest + leggings + boots);
        chest += remainder;
        return switch (pEquipmentSlot) {
            case EquipmentSlot.HEAD -> head;
            case EquipmentSlot.CHEST -> chest;
            case EquipmentSlot.LEGS -> leggings;
            case EquipmentSlot.FEET -> boots;
            default -> 0.0f;
        };
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        if (pEquipmentSlot == this.f_265916_.m_266308_()) {
            ImmutableMultimap.Builder m = ImmutableMultimap.builder();
            m.putAll(this.getModifiedMultimap());
            ArmorMaterial armorMaterial = this.m_40401_();
            if (armorMaterial instanceof TridotArmorMat) {
                TridotArmorMat armorRegistry = (TridotArmorMat)armorMaterial;
                armorRegistry.builder().attributeMap.forEach((attrSupplier, data) -> {
                    AttributeModifier modifier1 = new AttributeModifier(this.uuid, "Attribute Modifier", (double)this.attrDist(armorRegistry.builder(), pEquipmentSlot, data.value()), data.operation());
                    m.put((Object)((Attribute)attrSupplier.get()), (Object)modifier1);
                });
            }
            return m.build();
        }
        return super.m_7167_(pEquipmentSlot);
    }

    @NotNull
    private Multimap<Attribute, AttributeModifier> getModifiedMultimap() {
        Multimap<Attribute, AttributeModifier> map = HashMultimap.create();
        if (!((Boolean)CommonConfig.PERCENT_ARMOR.get()).booleanValue()) {
            map.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(this.uuid, "Armor modifier", (double)this.defense, AttributeModifier.Operation.ADDITION));
            map.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(this.uuid, "Armor toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION));
            if (this.knockbackResistance > 0.0f) {
                map.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(this.uuid, "Armor knockback resistance", (double)this.knockbackResistance, AttributeModifier.Operation.ADDITION));
            }
        } else {
            map = this.defaultModifiers;
        }
        return map;
    }
}

