/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.armor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.common.registry.item.armor.TridotArmorMat;
import pro.komaru.tridot.common.registry.item.builders.AbstractArmorBuilder;

public abstract class AbstractArmorRegistry
implements ArmorMaterial,
TridotArmorMat {
    public AbstractArmorBuilder<?> builder;
    public static final Map<ArmorMaterial, List<AbstractArmorBuilder.ArmorEffectData>> EFFECTS = new HashMap<ArmorMaterial, List<AbstractArmorBuilder.ArmorEffectData>>();
    public static final Map<ArmorMaterial, List<AbstractArmorBuilder.HitEffectData>> HIT_EFFECTS = new HashMap<ArmorMaterial, List<AbstractArmorBuilder.HitEffectData>>();

    public AbstractArmorRegistry(AbstractArmorBuilder<?> builder, List<AbstractArmorBuilder.ArmorEffectData> data, List<AbstractArmorBuilder.HitEffectData> hitData) {
        this.builder = builder;
        if (data != null) {
            EFFECTS.put(this, data);
        }
        if (hitData != null) {
            HIT_EFFECTS.put(this, hitData);
        }
    }

    @Override
    public AbstractArmorBuilder<?> builder() {
        return this.builder;
    }

    public int m_266425_(ArmorItem.Type pType) {
        return this.builder.durability[pType.ordinal()] * this.builder.durabilityMultiplier;
    }

    @Override
    public float getPercentDefenseForType(ArmorItem.Type pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> this.builder.headProtectionAmount;
            case ArmorItem.Type.CHESTPLATE -> this.builder.chestplateProtectionAmount;
            case ArmorItem.Type.LEGGINGS -> this.builder.leggingsProtectionAmount;
            case ArmorItem.Type.BOOTS -> this.builder.bootsProtectionAmount;
        };
    }

    public int m_7366_(ArmorItem.Type pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> (int)this.builder.headProtectionAmount;
            case ArmorItem.Type.CHESTPLATE -> (int)this.builder.chestplateProtectionAmount;
            case ArmorItem.Type.LEGGINGS -> (int)this.builder.leggingsProtectionAmount;
            case ArmorItem.Type.BOOTS -> (int)this.builder.bootsProtectionAmount;
        };
    }

    public int m_6646_() {
        return this.builder.enchantmentValue;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return this.builder.equipSound;
    }

    @NotNull
    public Ingredient m_6230_() {
        return this.builder.repairIngredient.get();
    }

    @NotNull
    public abstract String m_6082_();

    public float m_6651_() {
        return this.builder.toughness;
    }

    public float m_6649_() {
        return this.builder.knockbackResistance;
    }
}

