/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.networking.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import pro.komaru.tridot.TridotLibClient;
import pro.komaru.tridot.client.sound.TridotSoundInstance;

public class DungeonSoundPacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final SoundEvent event;

    public DungeonSoundPacket(SoundEvent event, double posX, double posY, double posZ) {
        this.event = event;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public static DungeonSoundPacket decode(FriendlyByteBuf buf) {
        ResourceLocation soundID = buf.m_130281_();
        SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundID);
        return new DungeonSoundPacket(event, buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(SoundEvent event) {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (TridotLibClient.DUNGEON_MUSIC_INSTANCE != null && soundManager.m_120403_((SoundInstance)TridotLibClient.DUNGEON_MUSIC_INSTANCE)) {
            return;
        }
        TridotLibClient.DUNGEON_MUSIC_INSTANCE = new TridotSoundInstance(event, SoundSource.MUSIC, Minecraft.m_91087_().f_91074_);
        soundManager.m_120367_((SoundInstance)TridotLibClient.DUNGEON_MUSIC_INSTANCE);
        if (!soundManager.m_120403_((SoundInstance)TridotLibClient.DUNGEON_MUSIC_INSTANCE)) {
            TridotLibClient.DUNGEON_MUSIC_INSTANCE = null;
        }
    }

    public static void handle(DungeonSoundPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            DungeonSoundPacket.playSound(msg.event);
        });
        ctx.get().setPacketHandled(true);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.event.m_11660_());
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }
}

