/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.particle.behavior;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.behavior.ParticleBehaviorBuilder;
import pro.komaru.tridot.client.gfx.particle.behavior.component.ParticleBehaviorComponent;
import pro.komaru.tridot.client.gfx.particle.data.SpinParticleData;

public class ParticleBehavior {
    public static final Random random = new Random();
    public SpinParticleData xSpinData;
    public SpinParticleData ySpinData;
    public SpinParticleData zSpinData;
    public float xOffset;
    public float yOffset;
    public float zOffset;
    public boolean firstSide;
    public boolean secondSide;
    public boolean camera;
    public boolean xRotCam;
    public boolean yRotCam;

    public ParticleBehavior(SpinParticleData xSpinData, SpinParticleData ySpinData, SpinParticleData zSpinData, float xOffset, float yOffset, float zOffset, boolean firstSide, boolean secondSide, boolean camera, boolean xRotCam, boolean yRotCam) {
        this.xSpinData = xSpinData;
        this.ySpinData = ySpinData;
        this.zSpinData = zSpinData;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.firstSide = firstSide;
        this.secondSide = secondSide;
        this.camera = camera;
        this.xRotCam = xRotCam;
        this.yRotCam = yRotCam;
    }

    public ParticleBehavior copy() {
        return new ParticleBehavior(this.xSpinData, this.ySpinData, this.zSpinData, this.xOffset, this.yOffset, this.zOffset, this.firstSide, this.secondSide, this.camera, this.xRotCam, this.yRotCam);
    }

    public static ParticleBehaviorBuilder create() {
        return new ParticleBehaviorBuilder(0.0f, 0.0f, 0.0f);
    }

    public static ParticleBehaviorBuilder create(float xOffset, float yOffset, float zOffset) {
        return new ParticleBehaviorBuilder((float)Math.toRadians(xOffset), (float)Math.toRadians(yOffset), (float)Math.toRadians(zOffset));
    }

    public ParticleBehaviorComponent getComponent() {
        return new ParticleBehaviorComponent();
    }

    public void init(GenericParticle particle) {
        ParticleBehaviorComponent component = particle.behaviorComponent = this.getComponent();
        component.xRoll = this.xSpinData.spinOffset + this.xSpinData.startingValue;
        component.randomXSpin = GenericParticle.pickRandomValue(0.0f, this.xSpinData.rsp1, this.xSpinData.rsp2);
        if (random.nextBoolean()) {
            component.randomXSpin = -component.randomXSpin;
        }
        component.xRoll += GenericParticle.pickRandomRollValue(0.0f, this.xSpinData.rso1, this.xSpinData.rso2);
        component.yRoll = this.ySpinData.spinOffset + this.ySpinData.startingValue;
        component.randomYSpin = GenericParticle.pickRandomValue(0.0f, this.ySpinData.rsp1, this.ySpinData.rsp2);
        if (random.nextBoolean()) {
            component.randomYSpin = -component.randomYSpin;
        }
        component.yRoll += GenericParticle.pickRandomRollValue(0.0f, this.ySpinData.rso1, this.ySpinData.rso2);
        component.zRoll = this.zSpinData.spinOffset + this.zSpinData.startingValue;
        component.randomZSpin = GenericParticle.pickRandomValue(0.0f, this.zSpinData.rsp1, this.zSpinData.rsp2);
        if (random.nextBoolean()) {
            component.randomZSpin = -component.randomZSpin;
        }
        component.zRoll += GenericParticle.pickRandomRollValue(0.0f, this.zSpinData.rso1, this.zSpinData.rso2);
        component.srx = GenericParticle.pickRandomValue(this.xSpinData.startingValue, this.xSpinData.rs1, this.xSpinData.rs2);
        component.mrx = GenericParticle.pickRandomValue(this.xSpinData.middleValue, this.xSpinData.rm1, this.xSpinData.rm2);
        component.erx = GenericParticle.pickRandomValue(this.xSpinData.endingValue, this.xSpinData.re1, this.xSpinData.re2);
        component.sry = GenericParticle.pickRandomValue(this.ySpinData.startingValue, this.xSpinData.rs1, this.xSpinData.rs2);
        component.mry = GenericParticle.pickRandomValue(this.ySpinData.middleValue, this.xSpinData.rm1, this.xSpinData.rm2);
        component.ery = GenericParticle.pickRandomValue(this.ySpinData.endingValue, this.xSpinData.re1, this.xSpinData.re2);
        component.srz = GenericParticle.pickRandomValue(this.zSpinData.startingValue, this.xSpinData.rs1, this.xSpinData.rs2);
        component.mrz = GenericParticle.pickRandomValue(this.zSpinData.middleValue, this.xSpinData.rm1, this.xSpinData.rm2);
        component.erz = GenericParticle.pickRandomValue(this.zSpinData.endingValue, this.xSpinData.re1, this.xSpinData.re2);
    }

    public void updateTraits(GenericParticle particle) {
        ParticleBehaviorComponent component = particle.behaviorComponent;
        component.xORoll = component.xRoll;
        component.xRoll = component.xRoll + this.xSpinData.getValue(particle.f_107224_, particle.f_107225_, component.srx, component.mrx, component.erx) + component.randomXSpin;
        component.yORoll = component.yRoll;
        component.yRoll = component.yRoll + this.ySpinData.getValue(particle.f_107224_, particle.f_107225_, component.sry, component.mry, component.ery) + component.randomYSpin;
        component.zORoll = component.zRoll;
        component.zRoll = component.zRoll + this.zSpinData.getValue(particle.f_107224_, particle.f_107225_, component.srz, component.mrz, component.erz) + component.randomZSpin;
    }

    public void updateRenderTraits(GenericParticle particle, float partialTicks) {
    }

    public void render(GenericParticle particle, VertexConsumer vertexConsumer, Camera renderInfo, float partialTicks) {
        if (particle.shouldRenderTraits) {
            this.updateRenderTraits(particle, partialTicks);
        }
        Vec3 pos = this.getPosition(particle, renderInfo, partialTicks);
        Quaternionf quaternionf = this.getRotate(particle, renderInfo, partialTicks);
        Vector3f[] avector3f = this.getQuad(particle, renderInfo, partialTicks);
        float f3 = particle.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(f3);
            vector3f.add((float)pos.m_7096_(), (float)pos.m_7098_(), (float)pos.m_7094_());
        }
        float u0 = particle.m_5970_();
        float u1 = particle.m_5952_();
        float v0 = particle.m_5951_();
        float v1 = particle.m_5950_();
        int light = particle.m_6355_(partialTicks);
        if (this.firstSide) {
            vertexConsumer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(u1, v1).m_85950_(particle.f_107227_, particle.f_107228_, particle.f_107229_, particle.f_107230_).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(u1, v0).m_85950_(particle.f_107227_, particle.f_107228_, particle.f_107229_, particle.f_107230_).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(u0, v0).m_85950_(particle.f_107227_, particle.f_107228_, particle.f_107229_, particle.f_107230_).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(u0, v1).m_85950_(particle.f_107227_, particle.f_107228_, particle.f_107229_, particle.f_107230_).m_85969_(light).m_5752_();
        }
        if (this.secondSide) {
            vertexConsumer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(u1, v1).m_85950_(particle.f_107227_, particle.f_107228_, particle.f_107229_, particle.f_107230_).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(u1, v0).m_85950_(particle.f_107227_, particle.f_107228_, particle.f_107229_, particle.f_107230_).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(u0, v0).m_85950_(particle.f_107227_, particle.f_107228_, particle.f_107229_, particle.f_107230_).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(u0, v1).m_85950_(particle.f_107227_, particle.f_107228_, particle.f_107229_, particle.f_107230_).m_85969_(light).m_5752_();
        }
    }

    public Vec3 getPosition(GenericParticle particle, Camera renderInfo, float partialTicks) {
        Vec3 vec3 = renderInfo.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)particle.f_107209_, (double)particle.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)particle.f_107210_, (double)particle.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)particle.f_107211_, (double)particle.f_107214_) - vec3.m_7094_());
        return new Vec3((double)x, (double)y, (double)z);
    }

    public Quaternionf getRotate(GenericParticle particle, Camera renderInfo, float partialTicks) {
        Quaternionf quaternionf = new Quaternionf();
        if (this.camera) {
            float x = this.xRotCam ? renderInfo.m_90589_() : 0.0f;
            float y = this.yRotCam ? renderInfo.m_90590_() : 0.0f;
            quaternionf.rotationYXZ(-y * ((float)Math.PI / 180), x * ((float)Math.PI / 180), 0.0f);
        }
        ParticleBehaviorComponent component = particle.behaviorComponent;
        quaternionf.rotateX(Mth.m_14179_((float)partialTicks, (float)component.xORoll, (float)component.xRoll) + this.xOffset);
        quaternionf.rotateY(Mth.m_14179_((float)partialTicks, (float)component.yORoll, (float)component.yRoll) + this.yOffset);
        quaternionf.rotateZ(Mth.m_14179_((float)partialTicks, (float)component.zORoll, (float)component.zRoll) + this.zOffset);
        if (particle.f_107231_ != 0.0f) {
            quaternionf.rotateY(Mth.m_14179_((float)partialTicks, (float)particle.f_107204_, (float)particle.f_107231_));
        }
        return quaternionf;
    }

    public Vector3f[] getQuad(GenericParticle particle, Camera renderInfo, float partialTicks) {
        return new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
    }
}

