/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class RegistryHelper {
    private RegistryHelper() {
    }

    public static String getItemRegistryName(Item item) {
        ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)item);
        if (rl != null) {
            return rl.toString();
        }
        return "";
    }

    public static ResourceLocation getRegistryName(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item));
    }

    public static ResourceLocation getRegistryName(Entity entity) {
        return RegistryHelper.getRegistryName(entity.m_6095_());
    }

    public static ResourceLocation getRegistryName(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    public static ResourceLocation getRegistryName(EntityType<?> entityType) {
        return Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
    }

    public static boolean registryNamesEqual(Item itemA, Item itemB) {
        return RegistryHelper.getRegistryName(itemA).equals((Object)RegistryHelper.getRegistryName(itemB));
    }

    public static ResourceLocation getRegistryName(MobEffect effect) {
        return Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect));
    }
}

