/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.util.FakePlayer;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItemWrapper;
import reliquary.reference.Settings;

public class PedestalShearsWrapper
implements IPedestalActionItemWrapper {
    private boolean isShearingBlock = false;
    private BlockPos blockPosBeingSheared;
    private final Queue<BlockPos> blockQueue = new ArrayDeque<BlockPos>();

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        int shearsRange;
        BlockPos pos = pedestal.getBlockPosition();
        if (this.shearAnimals(stack, level, pedestal, pos, shearsRange = ((Integer)Settings.COMMON.blocks.pedestal.shearsWrapperRange.get()).intValue())) {
            return;
        }
        if (!this.isShearingBlock) {
            pedestal.setActionCoolDown((Integer)Settings.COMMON.blocks.pedestal.shearsWrapperCooldown.get());
        }
        if (stack.m_41613_() == 0) {
            pedestal.destroyItem();
        }
    }

    private boolean shearAnimals(ItemStack stack, Level level, IPedestal pedestal, BlockPos pos, int shearsRange) {
        return pedestal.getFakePlayer().map(fakePlayer -> {
            if (!this.shearAnimals(stack, level, (FakePlayer)fakePlayer, pos, shearsRange) && !this.shearBlocks(stack, level, pedestal, (FakePlayer)fakePlayer, pos, shearsRange)) {
                pedestal.setActionCoolDown(100);
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }

    private boolean shearBlocks(ItemStack stack, Level world, IPedestal pedestal, FakePlayer fakePlayer, BlockPos pos, int shearsRange) {
        if (!this.isShearingBlock) {
            if (this.blockQueue.isEmpty()) {
                this.updateQueue(stack, world, pos, shearsRange);
                if (this.blockQueue.isEmpty()) {
                    return false;
                }
            }
            this.blockPosBeingSheared = this.blockQueue.remove();
            BlockState blockState = world.m_8055_(this.blockPosBeingSheared);
            if (this.isShearableBlock(stack, world, blockState)) {
                float hardness = blockState.m_60800_((BlockGetter)world, this.blockPosBeingSheared);
                float digSpeed = stack.m_41720_().m_8102_(stack, blockState);
                pedestal.setActionCoolDown((int)(hardness * 1.5f * 20.0f / digSpeed));
                this.isShearingBlock = true;
            }
        } else {
            stack.m_41720_().onBlockStartBreak(stack, this.blockPosBeingSheared, (Player)fakePlayer);
            BlockState blockState = world.m_8055_(this.blockPosBeingSheared);
            if (blockState.m_60734_() instanceof BeehiveBlock) {
                this.shearBeehive(world, this.blockPosBeingSheared, blockState, stack);
            } else if (world.m_7471_(this.blockPosBeingSheared, false)) {
                Block.m_49881_((BlockState)blockState, (Level)world, (BlockPos)pos, null, (Entity)fakePlayer, (ItemStack)new ItemStack((ItemLike)Items.f_42574_));
                world.m_46796_(2001, this.blockPosBeingSheared, Block.m_49956_((BlockState)blockState));
                stack.m_220157_(1, world.m_213780_(), null);
            }
            this.isShearingBlock = false;
        }
        return true;
    }

    private boolean isShearableBlock(ItemStack stack, Level world, BlockState blockState) {
        IForgeShearable shearable;
        Block block = blockState.m_60734_();
        return block instanceof IForgeShearable && (shearable = (IForgeShearable)block).isShearable(stack, world, this.blockPosBeingSheared) || block instanceof BeehiveBlock && (Integer)blockState.m_61143_((Property)BeehiveBlock.f_49564_) >= 5;
    }

    private void shearBeehive(Level world, BlockPos pos, BlockState blockState, ItemStack stack) {
        int honeyLevel = (Integer)blockState.m_61143_((Property)BeehiveBlock.f_49564_);
        if (honeyLevel >= 5) {
            world.m_5594_(null, pos, SoundEvents.f_11697_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BeehiveBlock.m_49600_((Level)world, (BlockPos)pos);
            ((BeehiveBlock)blockState.m_60734_()).m_49594_(world, blockState, pos, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
            stack.m_220157_(1, world.m_213780_(), null);
        }
    }

    private void updateQueue(ItemStack stack, Level world, BlockPos pos, int shearsRange) {
        for (int y = pos.m_123342_() - shearsRange; y <= pos.m_123342_() + shearsRange; ++y) {
            for (int x = pos.m_123341_() - shearsRange; x <= pos.m_123341_() + shearsRange; ++x) {
                for (int z = pos.m_123343_() - shearsRange; z <= pos.m_123343_() + shearsRange; ++z) {
                    BlockPos currentBlockPos = new BlockPos(x, y, z);
                    BlockState blockState = world.m_8055_(currentBlockPos);
                    if (!this.isShearableBlock(stack, world, blockState)) continue;
                    this.blockQueue.add(currentBlockPos);
                }
            }
        }
    }

    private boolean shearAnimals(ItemStack stack, Level world, FakePlayer fakePlayer, BlockPos pos, int shearsRange) {
        List entities = world.m_45976_(Animal.class, new AABB(pos.m_7918_(-shearsRange, -shearsRange, -shearsRange), pos.m_7918_(shearsRange, shearsRange, shearsRange)));
        for (Animal animal : entities) {
            IForgeShearable shearable;
            if (!(animal instanceof IForgeShearable) || !(shearable = (IForgeShearable)animal).isShearable(stack, world, animal.m_20183_())) continue;
            fakePlayer.m_21008_(InteractionHand.MAIN_HAND, stack);
            fakePlayer.m_36157_((Entity)animal, InteractionHand.MAIN_HAND);
            return true;
        }
        return false;
    }
}

