/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraftforge.common.IPlantable;
import reliquary.item.util.FilteredItemStack;
import reliquary.item.util.FilteredItemStackHandler;
import reliquary.reference.Settings;

public class HarvestRodItemStackHandler
extends FilteredItemStackHandler {
    public static final int BONEMEAL_SLOT = 0;

    private static List<FilteredItemStack> getDefaultStacks() {
        ArrayList<FilteredItemStack> stacks = new ArrayList<FilteredItemStack>();
        stacks.add(new FilteredItemStack(Items.f_42499_, (int)((Integer)Settings.COMMON.items.harvestRod.boneMealLimit.get()), (int)((Integer)Settings.COMMON.items.harvestRod.boneMealWorth.get()), false));
        return stacks;
    }

    public HarvestRodItemStackHandler() {
        super(HarvestRodItemStackHandler.getDefaultStacks());
        this.setDynamicSlotNumber();
    }

    @Override
    protected int getDynamicStackLimit() {
        return (Integer)Settings.COMMON.items.harvestRod.maxCapacityPerPlantable.get();
    }

    @Override
    protected boolean isValidForStackSlot(ItemStack stack, int stackSlot) {
        if (stackSlot == 0) {
            return stack.m_41720_() == Items.f_42499_;
        }
        return super.isValidForStackSlot(stack, stackSlot);
    }

    @Override
    protected boolean isValidForDynamicStack(ItemStack stack) {
        return this.isPlantable(stack);
    }

    private boolean isPlantable(ItemStack stack) {
        ItemNameBlockItem itemNameBlockItem;
        Item item = stack.m_41720_();
        return item instanceof IPlantable || item instanceof ItemNameBlockItem && (itemNameBlockItem = (ItemNameBlockItem)item).m_40614_() instanceof BonemealableBlock;
    }

    public int getBoneMealCount() {
        return this.getTotalAmount(0);
    }

    public void setBoneMealCount(int boneMealCount) {
        this.setTotalCount(0, boneMealCount);
    }

    public Optional<PlantableSlotInserted> insertPlantable(ItemStack stack) {
        for (int slot = 1; slot < this.getSlots(); ++slot) {
            ItemStack result = this.insertItem(slot, stack, false);
            if (result.m_41613_() >= stack.m_41613_()) continue;
            return Optional.of(new PlantableSlotInserted(slot, stack.m_41613_() - result.m_41613_()));
        }
        return Optional.empty();
    }

    public int getCountPlantable() {
        return this.getStackSlots() - 1;
    }

    public record PlantableSlotInserted(int slot, int countInserted) {
        public int getSlot() {
            return this.slot;
        }

        public int getCountInserted() {
            return this.countInserted;
        }
    }
}

