/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.item.ToggleableItem;
import reliquary.item.util.IScrollableItem;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.NBTHelper;
import reliquary.util.NoPlayerBlockItemUseContext;
import reliquary.util.RegistryHelper;
import reliquary.util.TooltipBuilder;

public class SojournerStaffItem
extends ToggleableItem
implements IScrollableItem {
    private static final int COOLDOWN = 10;
    private static final String ITEMS_TAG = "Items";
    private static final String QUANTITY_TAG = "Quantity";
    private static final String CURRENT_INDEX_TAG = "Current";

    public SojournerStaffItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_ || world.m_46467_() % 10L != 0L || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isEnabled(stack)) {
            this.scanForMatchingTorchesToFillInternalStorage(stack, player);
        }
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack stack, Player player, double scrollDelta) {
        if (player.m_9236_().f_46443_) {
            return InteractionResult.PASS;
        }
        this.cycleTorchMode(stack, scrollDelta > 0.0);
        return InteractionResult.SUCCESS;
    }

    private void scanForMatchingTorchesToFillInternalStorage(ItemStack stack, Player player) {
        for (String torch : (List)Settings.COMMON.items.sojournerStaff.torches.get()) {
            this.consumeAndCharge(player, (Integer)Settings.COMMON.items.sojournerStaff.maxCapacityPerItemType.get() - this.getInternalStorageItemCount(stack, torch), 1, (ItemStack ist) -> RegistryHelper.getItemRegistryName(ist.m_41720_()).equals(torch), 16, (int chargeToAdd) -> this.addItemToInternalStorage(stack, torch, chargeToAdd));
        }
    }

    public ItemStack getCurrentTorch(ItemStack stack) {
        return SojournerStaffItem.getItem(this.getCurrentTorchTag(stack));
    }

    public int getTorchCount(ItemStack stack) {
        return this.getCurrentTorchTag(stack).m_128451_(QUANTITY_TAG);
    }

    private CompoundTag getCurrentTorchTag(ItemStack stack) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        ListTag tagList = this.getItemListTag(tagCompound);
        int current = this.getCurrentIndex(tagCompound, tagList);
        return tagList.m_128728_(current);
    }

    private ListTag getItemListTag(CompoundTag tagCompound) {
        return tagCompound.m_128437_(ITEMS_TAG, 10);
    }

    private void cycleTorchMode(ItemStack stack, boolean next) {
        ItemStack currentTorch = this.getCurrentTorch(stack);
        if (currentTorch.m_41619_()) {
            return;
        }
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        ListTag tagList = this.getItemListTag(tagCompound);
        if (tagList.size() == 1) {
            return;
        }
        int current = this.getCurrentIndex(tagCompound, tagList);
        tagCompound.m_128405_(CURRENT_INDEX_TAG, Math.floorMod(current + (next ? 1 : -1), tagList.size()));
    }

    private int getCurrentIndex(CompoundTag tagCompound, ListTag tagList) {
        int current = tagCompound.m_128451_(CURRENT_INDEX_TAG);
        if (tagList.size() <= current) {
            tagCompound.m_128405_(CURRENT_INDEX_TAG, 0);
        }
        return current;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack staff, @Nullable Level world, TooltipBuilder tooltipBuilder) {
        StringJoiner joiner = new StringJoiner(";");
        this.iterateItems(staff, tag -> {
            ItemStack containedItem = SojournerStaffItem.getItem(tag);
            int quantity = tag.m_128451_(QUANTITY_TAG);
            joiner.add(containedItem.m_41786_().getString() + ": " + quantity);
        }, () -> false);
        if (this.getTorchCount(staff) > 0) {
            tooltipBuilder.data(this, ".tooltip.contents", joiner.toString());
            tooltipBuilder.data(this, ".tooltip.placing", this.getCurrentTorch(staff).m_41786_().getString());
        }
        if (this.isEnabled(staff)) {
            tooltipBuilder.absorbActive(new ItemStack((ItemLike)Blocks.f_50081_).m_41786_().getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    private static ItemStack getItem(CompoundTag tagItemData) {
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tagItemData.m_128461_("Name"))));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return this.placeTorch(context);
    }

    private InteractionResult placeTorch(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        ItemStack stack = context.m_43722_();
        BlockPos placeBlockAt = pos.m_121945_(face);
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack torch = this.getCurrentTorch(stack);
        if (player == null || torch.m_41619_() || !(torch.m_41720_() instanceof BlockItem)) {
            return InteractionResult.FAIL;
        }
        if (!player.m_36204_(placeBlockAt, face, stack) || player.m_6047_()) {
            return InteractionResult.PASS;
        }
        player.m_6674_(hand);
        Block blockToPlace = ((BlockItem)torch.m_41720_()).m_40614_();
        NoPlayerBlockItemUseContext placeContext = new NoPlayerBlockItemUseContext(world, placeBlockAt, new ItemStack((ItemLike)blockToPlace), face);
        if (!placeContext.m_7059_() || !this.removeTorches(player, stack, torch, placeBlockAt)) {
            return InteractionResult.FAIL;
        }
        ((BlockItem)torch.m_41720_()).m_40576_((BlockPlaceContext)placeContext);
        double gauss = 0.5 + (double)(world.f_46441_.m_188501_() / 2.0f);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)placeBlockAt.m_123341_() + 0.5, (double)placeBlockAt.m_123342_() + 0.5, (double)placeBlockAt.m_123343_() + 0.5, gauss, gauss, 0.0);
        return InteractionResult.SUCCESS;
    }

    private boolean removeTorches(Player player, ItemStack staff, ItemStack torch, BlockPos placeBlockAt) {
        if (!player.m_7500_()) {
            int distance = (int)player.m_20299_(1.0f).m_82554_(new Vec3((double)placeBlockAt.m_123341_(), (double)placeBlockAt.m_123342_(), (double)placeBlockAt.m_123343_()));
            int cost = 1 + distance / (Integer)Settings.COMMON.items.sojournerStaff.tilePerCostMultiplier.get();
            Item torchItem = torch.m_41720_();
            boolean result = this.removeItemFromInternalStorage(staff, torchItem, cost, false, player);
            if (result && torchItem != Items.f_42000_ && this.getInternalStorageItemCount(staff, torchItem) <= 0) {
                this.removeItemTagInInternalStorage(staff, torchItem);
                this.cycleTorchMode(staff, false);
            }
            return result;
        }
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!player.m_6144_()) {
            HitResult rayTraceResult = this.longRayTrace(world, player);
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
                this.placeTorch(new UseOnContext(player, hand, (BlockHitResult)rayTraceResult));
            } else {
                ItemStack staff = player.m_21120_(hand);
                CompoundTag torchTag = this.getCurrentTorchTag(staff);
                ItemStack torch = SojournerStaffItem.getItem(torchTag);
                int count = torchTag.m_128451_(QUANTITY_TAG);
                torch.m_41764_(Math.min(count, torch.m_41741_()));
                player.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(playerInventory -> {
                    int inserted = InventoryHelper.insertIntoInventory(torch, playerInventory);
                    this.removeItemFromInternalStorage(staff, torch.m_41720_(), inserted, false, player);
                });
            }
        }
        return super.m_7203_(world, player, hand);
    }

    private HitResult longRayTrace(Level worldIn, Player player) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3d = player.m_20299_(1.0f);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = ((Integer)Settings.COMMON.items.sojournerStaff.maxRange.get()).intValue();
        Vec3 vec3d1 = vec3d.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)player));
    }
}

