/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.util.TooltipBuilder;

public class MagicbaneItem
extends SwordItem
implements ICreativeTabItemGenerator {
    private static final AttributeModifier SPEED_ATTRIBUTE = new AttributeModifier(f_41375_, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION);

    public MagicbaneItem() {
        super((Tier)Tiers.GOLD, 3, -2.4f, new Item.Properties().m_41503_(16).setNoRepair().m_41497_(Rarity.EPIC));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public void m_7373_(ItemStack magicBane, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        TooltipBuilder.of(tooltip).itemTooltip((Item)this);
    }

    public float m_8102_(ItemStack stack, BlockState blockState) {
        return blockState.m_60734_() == Blocks.f_50033_ ? 15.0f : 1.5f;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int random = target.m_9236_().f_46441_.m_188503_(16);
        switch (random) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 2));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2));
                break;
            }
            case 12: 
            case 13: {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 2));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 2));
                break;
            }
            case 14: {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, 2));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 2));
                break;
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot != EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of();
        }
        ListTag enchants = stack.m_41785_();
        int attackDamage = 4;
        for (int enchant = 0; enchant < enchants.size(); ++enchant) {
            attackDamage += enchants.m_128728_(enchant).m_128448_("lvl");
        }
        return ImmutableMultimap.of((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION), (Object)Attributes.f_22283_, (Object)SPEED_ATTRIBUTE);
    }
}

