/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import reliquary.item.ToggleableItem;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.NBTHelper;
import reliquary.util.RegistryHelper;
import reliquary.util.TooltipBuilder;

public class InfernalTearItem
extends ToggleableItem {
    private static final String ENABLED_TAG = "enabled";
    private static final int COOLDOWN = 4;
    private static final int NOTHING_FOUND_COOLDOWN = 20;

    public InfernalTearItem() {
        super(new Item.Properties().m_41487_(1).setNoRepair());
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        return super.getName(stack).m_130940_(ChatFormatting.RED);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_ || world.m_46467_() % 4L != 0L || !this.isEnabled(stack) || this.isInCooldown(stack, world) || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack tearStack = InfernalTearItem.getStackFromTear(stack);
        if (tearStack.m_41619_()) {
            this.resetTear(stack);
            return;
        }
        Optional<Integer> experience = Settings.COMMON.items.infernalTear.getItemExperience(RegistryHelper.getItemRegistryName(tearStack.m_41720_()));
        if (experience.isEmpty()) {
            this.resetTear(stack);
            return;
        }
        int countConsumed = InventoryHelper.consumeItemStack(ist -> ItemHandlerHelper.canItemStacksStack((ItemStack)tearStack, (ItemStack)ist), player, 4).m_41613_();
        if (countConsumed > 0) {
            player.m_6756_(experience.get() * countConsumed);
        } else {
            this.setCooldown(stack, world, 20);
        }
    }

    private void resetTear(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_("item");
            tag.m_128473_(ENABLED_TAG);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (InfernalTearItem.getStackFromTear(stack).m_41619_()) {
            TooltipBuilder.of(tooltip).description("tooltip.reliquary.tear_empty", new Object[0]);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack stack, @Nullable Level world, TooltipBuilder tooltipBuilder) {
        ItemStack contents = InfernalTearItem.getStackFromTear(stack);
        String itemName = contents.m_41786_().getString();
        tooltipBuilder.data("tooltip.reliquary.tear", itemName);
        if (this.isEnabled(stack)) {
            tooltipBuilder.absorbActive(itemName);
        }
        tooltipBuilder.description("tooltip.reliquary.absorb", new Object[0]);
        tooltipBuilder.description(this, ".infernal_tear.absorb_unset", new Object[0]);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return !InfernalTearItem.getStackFromTear(stack).m_41619_();
    }

    public static ItemStack getStackFromTear(ItemStack tear) {
        CompoundTag itemNBT = NBTHelper.getTagCompound("item", tear);
        if (itemNBT.m_128456_()) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)itemNBT);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack returnStack;
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder<ItemStack> actionResult = super.m_7203_(world, player, hand);
        if (player.m_6144_() && !this.isEnabled(stack)) {
            return actionResult;
        }
        ItemStack itemStack = (ItemStack)actionResult.m_19095_();
        CompoundTag nbt = itemStack.m_41783_();
        if (!player.m_6144_() && !InfernalTearItem.getStackFromTear(itemStack).m_41619_()) {
            NBTHelper.remove(nbt, "item");
            NBTHelper.remove(nbt, ENABLED_TAG);
            return actionResult;
        }
        if (!InfernalTearItem.getStackFromTear(itemStack).m_41619_()) {
            return actionResult;
        }
        if (!(!player.m_6144_() && this.isEnabled(itemStack) || (returnStack = InventoryHelper.getItemHandlerFrom(player).map(handler -> this.buildTear(itemStack, (IItemHandler)handler)).orElse(ItemStack.f_41583_)).m_41619_())) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)returnStack);
        }
        if (this.isEnabled(itemStack)) {
            this.toggleEnabled(itemStack);
        }
        return actionResult;
    }

    private ItemStack buildTear(ItemStack stack, IItemHandler inventory) {
        ItemStack tear = new ItemStack((ItemLike)this, 1);
        ItemStack target = this.getTargetAlkahestItem(stack, inventory);
        if (target.m_41619_()) {
            return ItemStack.f_41583_;
        }
        InfernalTearItem.setTearTarget(tear, target);
        if (Boolean.TRUE.equals(Settings.COMMON.items.infernalTear.absorbWhenCreated.get())) {
            NBTHelper.putBoolean(ENABLED_TAG, stack, true);
        }
        return tear;
    }

    public static void setTearTarget(ItemStack tear, ItemStack target) {
        NBTHelper.putTagCompound("item", tear, target.m_41739_(new CompoundTag()));
    }

    private ItemStack getTargetAlkahestItem(ItemStack self, IItemHandler inventory) {
        ItemStack targetItem = ItemStack.f_41583_;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack.m_41619_() || self.m_41720_() == stack.m_41720_() || stack.m_41741_() == 1 || stack.m_41783_() != null || Settings.COMMON.items.infernalTear.getItemExperience(RegistryHelper.getItemRegistryName(stack.m_41720_())).isEmpty() || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.m_41777_();
        }
        return targetItem;
    }
}

