/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting.alkahestry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import reliquary.crafting.conditions.AlkahestryEnabledCondition;
import reliquary.init.ModItems;
import reliquary.util.RegistryHelper;

public class DrainRecipeBuilder {
    private final Item itemResult;
    private final int charge;

    private DrainRecipeBuilder(ItemLike itemResult, int charge) {
        this.itemResult = itemResult.m_5456_();
        this.charge = charge;
    }

    public static DrainRecipeBuilder drainRecipe(ItemLike result, int charge) {
        return new DrainRecipeBuilder(result, charge);
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation fullId = new ResourceLocation("reliquary", "alkahestry/drain/" + id.m_135815_());
        ConditionalRecipe.builder().addCondition((ICondition)new AlkahestryEnabledCondition()).addRecipe(conditionalConsumer -> conditionalConsumer.accept(new Result(fullId, this.itemResult, this.charge))).build(consumer, fullId);
    }

    public static class Result
    implements FinishedRecipe {
        private final Item itemResult;
        private final int charge;
        private final ResourceLocation id;

        public Result(ResourceLocation id, Item itemResult, int charge) {
            this.id = id;
            this.itemResult = itemResult;
            this.charge = charge;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("charge", (Number)this.charge);
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", RegistryHelper.getItemRegistryName(this.itemResult));
            json.add("result", (JsonElement)resultObject);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModItems.ALKAHESTRY_DRAIN_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

