/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModItems;
import reliquary.item.AlkahestryTomeItem;
import reliquary.reference.Settings;

public class AlkahestryDrainRecipe
implements CraftingRecipe {
    private final int chargeToDrain;
    private final ItemStack result;
    private final ResourceLocation id;
    private final Ingredient tomeIngredient;

    private AlkahestryDrainRecipe(ResourceLocation id, int chargeToDrain, ItemStack result) {
        this.chargeToDrain = chargeToDrain;
        this.result = result;
        this.id = id;
        this.tomeIngredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{AlkahestryTomeItem.setCharge(new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get()), (Integer)Settings.COMMON.items.alkahestryTome.chargeLimit.get())});
        AlkahestryRecipeRegistry.setDrainRecipe(this);
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        boolean hasTome = false;
        ItemStack tome = ItemStack.f_41583_;
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (stack.m_41619_()) continue;
            if (!hasTome && stack.m_41720_() == ModItems.ALKAHESTRY_TOME.get()) {
                hasTome = true;
                tome = stack;
                continue;
            }
            return false;
        }
        return hasTome && AlkahestryTomeItem.getCharge(tome) > 0;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.tomeIngredient});
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack tome = this.getTome(inv).m_41777_();
        int charge = AlkahestryTomeItem.getCharge(tome);
        ItemStack ret = this.result.m_41777_();
        ret.m_41764_(Math.min(ret.m_41741_(), charge / this.chargeToDrain));
        return ret;
    }

    private ItemStack getTome(CraftingContainer inv) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (stack.m_41720_() != ModItems.ALKAHESTRY_TOME.get()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 1;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList ret = super.m_7457_((Container)inv);
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (stack.m_41720_() != ModItems.ALKAHESTRY_TOME.get()) continue;
            ItemStack tome = stack.m_41777_();
            int charge = AlkahestryTomeItem.getCharge(tome);
            int itemCount = Math.min(this.result.m_41741_(), charge / this.chargeToDrain);
            AlkahestryTomeItem.useCharge(tome, itemCount * this.chargeToDrain);
            ret.set(slot, (Object)tome);
        }
        return ret;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItems.ALKAHESTRY_DRAIN_SERIALIZER.get();
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<AlkahestryDrainRecipe> {
        public AlkahestryDrainRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int chargeToDrain = GsonHelper.m_13927_((JsonObject)json, (String)"charge");
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return new AlkahestryDrainRecipe(recipeId, chargeToDrain, result);
        }

        @Nullable
        public AlkahestryDrainRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new AlkahestryDrainRecipe(recipeId, buffer.readInt(), buffer.m_130267_());
        }

        public void toNetwork(FriendlyByteBuf buffer, AlkahestryDrainRecipe recipe) {
            buffer.writeInt(recipe.chargeToDrain);
            buffer.m_130055_(recipe.result);
        }
    }
}

