/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import reliquary.entity.shot.ShotEntityBase;

@OnlyIn(value=Dist.CLIENT)
public class ShotRenderer<T extends ShotEntityBase>
extends EntityRenderer<T> {
    private final Map<EntityType<?>, RenderType> entityCutOuts = new HashMap();

    public ShotRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.1f, 0.1f, 0.1f);
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        Matrix3f normal = pose.m_252943_();
        VertexConsumer vertexBuilder = buffer.m_6299_(this.getEntityCutOut(entity));
        this.addVertex(vertexBuilder, matrix, normal, packedLight, -0.5f, -0.25f, 0, 1);
        this.addVertex(vertexBuilder, matrix, normal, packedLight, 0.5f, -0.25f, 1, 1);
        this.addVertex(vertexBuilder, matrix, normal, packedLight, 0.5f, 0.75f, 1, 0);
        this.addVertex(vertexBuilder, matrix, normal, packedLight, -0.5f, 0.75f, 0, 0);
        poseStack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void addVertex(VertexConsumer vertexBuilder, Matrix4f matrix, Matrix3f normal, int packedLight, float x, float y, int u, int v) {
        vertexBuilder.m_252986_(matrix, x, y, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private RenderType getEntityCutOut(T entity) {
        if (!this.entityCutOuts.containsKey(entity.m_6095_())) {
            this.entityCutOuts.put(entity.m_6095_(), RenderType.m_110452_((ResourceLocation)((ShotEntityBase)((Object)entity)).getShotTexture()));
        }
        return this.entityCutOuts.get(entity.m_6095_());
    }

    public ResourceLocation getTextureLocation(T entityShot) {
        return ((ShotEntityBase)((Object)entityShot)).getShotTexture();
    }
}

