/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui.hud;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import reliquary.client.gui.components.Box;
import reliquary.client.gui.components.Component;
import reliquary.client.gui.components.ItemStackPane;
import reliquary.reference.Settings;

public class CharmPane
extends Component {
    private static Box mainPane = Box.createVertical(new Component[0]);
    private static final Lock lock = new ReentrantLock();
    private static final Map<Integer, CharmToDraw> charmsToDraw = new HashMap<Integer, CharmToDraw>();

    @Override
    public int getHeightInternal() {
        return mainPane.getHeight();
    }

    @Override
    public int getWidthInternal() {
        return mainPane.getWidth();
    }

    @Override
    public int getPadding() {
        return 0;
    }

    @Override
    public boolean shouldRender() {
        CharmPane.removeExpiredMobCharms();
        lock.lock();
        boolean isEmpty = charmsToDraw.isEmpty();
        lock.unlock();
        return !isEmpty;
    }

    private static void updateCharmsPane() {
        lock.lock();
        Component[] components = new Component[charmsToDraw.size()];
        AtomicInteger i = new AtomicInteger(0);
        charmsToDraw.forEach((slot, charmToDraw) -> {
            int index = i.getAndIncrement();
            components[index] = new ItemStackPane(charmToDraw.getCharm(), true);
        });
        lock.unlock();
        mainPane = Box.createVertical(components);
    }

    @Override
    public void renderInternal(GuiGraphics guiGraphics, int x, int y) {
        mainPane.render(guiGraphics, x, y);
    }

    public static void addCharmToDraw(ItemStack charm, int slot) {
        int maxMobCharmsToDisplay = (Integer)Settings.COMMON.items.mobCharm.maxCharmsToDisplay.get();
        lock.lock();
        if (charmsToDraw.size() == maxMobCharmsToDisplay) {
            charmsToDraw.remove(0);
        }
        if (charm.m_41619_()) {
            charmsToDraw.remove(slot);
        } else {
            charmsToDraw.put(slot, new CharmToDraw(charm, System.currentTimeMillis()));
        }
        lock.unlock();
        CharmPane.updateCharmsPane();
    }

    private static void removeExpiredMobCharms() {
        int secondsToExpire = 4;
        boolean changed = false;
        lock.lock();
        Iterator<Map.Entry<Integer, CharmToDraw>> iterator = charmsToDraw.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, CharmToDraw> entry = iterator.next();
            CharmToDraw charmToDraw = entry.getValue();
            if (Boolean.TRUE.equals(Settings.COMMON.items.mobCharm.keepAlmostDestroyedDisplayed.get()) && (double)charmToDraw.getCharm().m_41773_() >= (double)charmToDraw.getCharm().m_41776_() * 0.9 || charmToDraw.time + (long)(secondsToExpire * 1000) >= System.currentTimeMillis()) continue;
            iterator.remove();
            changed = true;
        }
        lock.unlock();
        if (changed) {
            CharmPane.updateCharmsPane();
        }
    }

    private static class CharmToDraw {
        final ItemStack charm;
        final long time;

        CharmToDraw(ItemStack charm, long time) {
            this.charm = charm;
            this.time = time;
        }

        ItemStack getCharm() {
            return this.charm;
        }
    }
}

