/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SandcastleBlock
extends HorizontalDirectionalBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final IntegerProperty EGGS_INSIDE = IntegerProperty.m_61631_((String)"eggs_inside", (int)0, (int)4);

    public SandcastleBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_60978_(0.7f).m_60918_(SoundType.f_56746_).m_278166_(PushReaction.DESTROY).m_60955_().m_60977_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)EGGS_INSIDE, (Comparable)Integer.valueOf(0))).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_49992_);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        this.destroySandcastle(pLevel, pState, pPos, pEntity, 50);
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        this.destroySandcastle(pLevel, pState, pPos, pEntity, 3);
    }

    private void destroySandcastle(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, int chance) {
        if (this.canBreakSandcastle(pEntity) && !pLevel.f_46443_ && pLevel.f_46441_.m_188503_(chance) == 0) {
            pLevel.m_5594_(null, pPos, SoundEvents.f_12332_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if ((Integer)pState.m_61143_((Property)EGGS_INSIDE) > 0) {
                pLevel.m_46597_(pPos, (BlockState)((BlockState)Blocks.f_50578_.m_49966_().m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)((Integer)pState.m_61143_((Property)EGGS_INSIDE)))).m_61124_((Property)TurtleEggBlock.f_57753_, (Comparable)((Integer)pState.m_61143_((Property)HATCH))));
            } else {
                pLevel.m_46961_(pPos, false);
            }
        }
    }

    private boolean canBreakSandcastle(Entity pEntity) {
        if (!(pEntity instanceof Turtle)) {
            if (!(pEntity instanceof LivingEntity)) {
                return false;
            }
            return pEntity instanceof Player;
        }
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, EGGS_INSIDE, HATCH});
    }

    public boolean m_6724_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)EGGS_INSIDE) > 0;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.shouldUpdateHatchLevel((Level)pLevel)) {
            int hatch = (Integer)pState.m_61143_((Property)HATCH);
            if (hatch < 2) {
                pLevel.m_5594_(null, pPos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(hatch + 1)), 2);
            } else {
                pLevel.m_5594_(null, pPos, SoundEvents.f_12535_, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
                pLevel.m_5594_(null, pPos, SoundEvents.f_12331_, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
                pLevel.m_7471_(pPos, false);
                for (int i = 0; i < (Integer)pState.m_61143_((Property)EGGS_INSIDE); ++i) {
                    pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
                    Turtle turtle = (Turtle)EntityType.f_20490_.m_20615_((Level)pLevel);
                    turtle.m_146762_(-24000);
                    turtle.m_30219_(pPos);
                    turtle.m_7678_((double)pPos.m_123341_() + 0.3 + (double)i * 0.2, (double)pPos.m_123342_(), (double)pPos.m_123343_() + 0.3, 0.0f, 0.0f);
                    pLevel.m_7967_((Entity)turtle);
                }
            }
        }
    }

    private boolean shouldUpdateHatchLevel(Level pLevel) {
        float time = pLevel.m_46942_(1.0f);
        if ((double)time < 0.69 && (double)time > 0.65) {
            return true;
        }
        return pLevel.f_46441_.m_188503_(2) == 0;
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pBlockEntity, ItemStack pTool) {
        super.m_6240_(pLevel, pPlayer, pPos, pState, pBlockEntity, pTool);
        if ((Integer)pState.m_61143_((Property)EGGS_INSIDE) > 0) {
            pLevel.m_46597_(pPos, (BlockState)((BlockState)Blocks.f_50578_.m_49966_().m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)((Integer)pState.m_61143_((Property)EGGS_INSIDE)))).m_61124_((Property)TurtleEggBlock.f_57753_, (Comparable)((Integer)pState.m_61143_((Property)HATCH))));
        }
    }
}

