/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment.damage;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.api.modules.lib.IDamageModifier;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.client.render.effect.StaffBeamEffect;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DefaultStaffDmgMod
implements IDamageModifier {
    @Override
    public IDamageModifier.EffectType getType() {
        return IDamageModifier.EffectType.STAFF_BEAM;
    }

    @Override
    public void addInformation(Map<Component, Component> map, @Nullable ModuleContext context, boolean stack) {
    }

    @Override
    public SoundEvent chargeSound() {
        return (SoundEvent)DESounds.STAFF_CHARGE_FIRE.get();
    }

    @Override
    public SoundEvent fireSound() {
        return SoundEvents.f_11705_;
    }

    @Override
    public int effectColour() {
        return 0;
    }

    @Override
    public void doDamageAndEffects(Level world, Vec3 pos, @Nullable HitResult traceResult, LivingEntity source, float baseDamage, float secondaryCharge, boolean isProjectile) {
        if (source == null) {
            return;
        }
        if (traceResult instanceof EntityHitResult) {
            pos = pos.m_82520_(0.0, (double)(((EntityHitResult)traceResult).m_82443_().m_20206_() / 2.0f), 0.0);
        } else if (traceResult != null) {
            pos = traceResult.m_82450_();
        }
        Vec3 finalPos = pos;
        DraconicNetwork.sendStaffEffect(source, 0, e -> e.writeVector(new Vector3(finalPos)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleEffect(LivingEntity source, MCDataInput data) {
        Vector3 pos = data.readVector();
        ClientLevel world = (ClientLevel)source.m_9236_();
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance((SoundEvent)DESounds.STAFF_HIT_DEFAULT.get(), SoundSource.PLAYERS, 10.0f, 1.0f, world.f_46441_, pos.pos()));
        mc.f_91061_.m_107344_((Particle)new StaffBeamEffect(world, source, pos));
    }
}

