/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.worldentity.ITickableWorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntityType;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianSpawnState;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.brandon3055.draconicevolution.world.ShieldedServerBossInfo;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Unit;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.Logger;

public class GuardianFightManager
extends WorldEntity
implements ITickableWorldEntity {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    public static final int CRYSTAL_DIST_FROM_CENTER = 90;
    public static final int CRYSTAL_HEIGHT_FROM_ORIGIN = 40;
    public static final float PROJECTILE_POWER = 15.0f;
    public static final float CHARGE_DAMAGE = 150.0f;
    public static final float COVER_FIRE_POWER = 15.0f;
    private Predicate<Entity> validPlayer;
    private final ShieldedServerBossInfo bossInfo = (ShieldedServerBossInfo)new ShieldedServerBossInfo((Component)Component.m_237115_((String)"entity.draconicevolution.draconic_guardian"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7005_(true).m_7006_(true);
    private int ticksSinceGuardianSeen;
    private int aliveCrystals;
    private int ticksSinceCrystalsScanned;
    private int ticksSinceLastPlayerScan;
    private boolean guardianKilled;
    private UUID guardianUniqueId;
    private BlockPos arenaOrigin;
    public GuardianSpawnState respawnState;
    private int respawnStateTicks;
    private List<BlockPos> crystalsPosCache;
    private List<BlockPos> crystalSpawnList;

    public GuardianFightManager() {
        super((WorldEntityType)DEContent.WE_GUARDIAN_MANAGER.get());
    }

    public GuardianFightManager(BlockPos origin) {
        super((WorldEntityType)DEContent.WE_GUARDIAN_MANAGER.get());
        this.arenaOrigin = origin;
        this.validPlayer = EntitySelector.f_20402_.and(EntitySelector.m_20410_((double)origin.m_123341_(), (double)origin.m_123342_(), (double)origin.m_123343_(), (double)250.0));
        this.respawnState = GuardianSpawnState.START_WAIT_FOR_PLAYER;
        this.bossInfo.m_142711_(0.0f);
        this.bossInfo.setShieldPower(0.0f);
    }

    public void tick() {
        ServerLevel world = (ServerLevel)this.level;
        this.bossInfo.m_8321_(!this.guardianKilled && this.respawnState != GuardianSpawnState.START_WAIT_FOR_PLAYER);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updatePlayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.bossInfo.m_8324_().isEmpty()) {
            world.m_7726_().m_8387_(TicketType.f_9443_, new ChunkPos(this.arenaOrigin), 12, (Object)Unit.INSTANCE);
            boolean areaLoaded = this.isFightAreaLoaded();
            if (this.respawnState != null) {
                this.respawnState.process(world, this, null, this.respawnStateTicks++, this.arenaOrigin);
            }
            if (!this.guardianKilled && this.respawnState == null) {
                if ((this.guardianUniqueId == null || ++this.ticksSinceGuardianSeen >= 1200) && areaLoaded) {
                    this.findOrCreateGuardian();
                    this.ticksSinceGuardianSeen = 0;
                }
                if (++this.ticksSinceCrystalsScanned >= 100 && areaLoaded) {
                    this.findAliveCrystals();
                    this.ticksSinceCrystalsScanned = 0;
                }
            }
        } else {
            world.m_7726_().m_8438_(TicketType.f_9443_, new ChunkPos(this.arenaOrigin), 12, (Object)Unit.INSTANCE);
        }
    }

    private void findOrCreateGuardian() {
        ServerLevel world = (ServerLevel)this.level;
        List<DraconicGuardianEntity> list = Streams.stream((Iterable)world.m_142646_().m_142273_()).filter(e -> e instanceof DraconicGuardianEntity).map(e -> (DraconicGuardianEntity)((Object)e)).toList();
        if (list.isEmpty()) {
            LOGGER.debug("Haven't seen the guardian, respawning it");
            this.createNewGuardian();
        } else {
            LOGGER.debug("Haven't seen our guardian, but found another one to use.");
            this.guardianUniqueId = list.get(0).m_20148_();
        }
    }

    protected void setRespawnState(GuardianSpawnState state) {
        if (this.respawnState == null) {
            throw new IllegalStateException("Guardian respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.respawnStateTicks = 0;
        if (state == GuardianSpawnState.END) {
            this.respawnState = null;
            this.guardianKilled = false;
            this.findAliveCrystals();
            DraconicGuardianEntity guardian = this.createNewGuardian();
            for (ServerPlayer serverplayerentity : this.bossInfo.m_8324_()) {
                CriteriaTriggers.f_10580_.m_68256_(serverplayerentity, (Entity)guardian);
            }
        } else {
            this.respawnState = state;
        }
    }

    private boolean isFightAreaLoaded() {
        for (int x = -8; x <= 8; ++x) {
            for (int z = 8; z <= 8; ++z) {
                ChunkPos pos = new ChunkPos(this.arenaOrigin);
                ChunkAccess ichunk = this.level.m_6522_(pos.f_45578_ + x, pos.f_45579_ + z, ChunkStatus.f_62326_, false);
                if (!(ichunk instanceof LevelChunk)) {
                    return false;
                }
                if (this.level.m_7726_().m_5563_(pos.f_45578_ + x, pos.f_45579_ + z)) continue;
                return false;
            }
        }
        return true;
    }

    private void updatePlayers() {
        ServerLevel world = (ServerLevel)this.level;
        HashSet validPlayers = Sets.newHashSet();
        for (ServerPlayer player : world.m_8795_(this.validPlayer)) {
            this.bossInfo.m_6543_(player);
            validPlayers.add(player);
        }
        HashSet invalidPlayers = Sets.newHashSet((Iterable)this.bossInfo.m_8324_());
        invalidPlayers.removeAll(validPlayers);
        for (ServerPlayer player : invalidPlayers) {
            this.bossInfo.m_6539_(player);
        }
    }

    public void processDragonDeath(DraconicGuardianEntity guardian) {
        this.bossInfo.m_142711_(0.0f);
        this.bossInfo.setShieldPower(0.0f);
        this.bossInfo.m_8321_(false);
        this.guardianKilled = true;
        BlockEntity tile = this.level.m_7702_(this.arenaOrigin);
        if (tile instanceof TileChaosCrystal) {
            ((TileChaosCrystal)tile).setDefeated();
        }
        GuardianFightManager manager = guardian.getFightManager();
        ItemEntity item = (ItemEntity)EntityType.f_20461_.m_20615_(guardian.m_9236_());
        if (manager != null && item != null) {
            item.m_32045_(new ItemStack((ItemLike)DEContent.DRAGON_HEART.get()));
            BlockPos podiumPos = manager.getArenaOrigin().m_6630_(20);
            item.m_7678_((double)podiumPos.m_123341_() + 0.5, (double)podiumPos.m_123342_(), (double)podiumPos.m_123343_() + 0.5, 0.0f, 0.0f);
            item.m_20334_(0.0, 0.0, 0.0);
            item.f_31985_ = -32767;
            item.m_20331_(true);
            item.m_20242_(true);
            item.getPersistentData().m_128379_("guardian_heart", true);
            guardian.m_9236_().m_7967_((Entity)item);
        }
        this.cleanUpAndDispose();
    }

    private DraconicGuardianEntity createNewGuardian() {
        ServerLevel world = (ServerLevel)this.level;
        world.m_46745_(this.guardianSpawnPos());
        DraconicGuardianEntity guardian = (DraconicGuardianEntity)((EntityType)DEContent.ENTITY_DRACONIC_GUARDIAN.get()).m_20615_((Level)world);
        assert (guardian != null);
        guardian.getPhaseManager().setPhase(PhaseType.START);
        guardian.m_7678_(this.guardianSpawnPos().m_123341_(), this.guardianSpawnPos().m_123342_(), this.guardianSpawnPos().m_123343_(), this.level.f_46441_.m_188501_() * 360.0f, 0.0f);
        guardian.setFightManager(this);
        guardian.setArenaOrigin(this.arenaOrigin);
        world.m_7967_((Entity)guardian);
        this.guardianUniqueId = guardian.m_20148_();
        return guardian;
    }

    public void guardianUpdate(DraconicGuardianEntity guardian) {
        if (guardian.m_20148_().equals(this.guardianUniqueId)) {
            this.bossInfo.m_142711_(guardian.m_21223_() / guardian.m_21233_());
            this.bossInfo.setShieldPower(guardian.getShieldPower() / (float)DEConfig.guardianShield);
            this.bossInfo.setImmune(guardian.getPhaseManager().getCurrentPhase().isInvulnerable());
            this.bossInfo.m_6451_(guardian.getShieldPower() > 0.0f ? BossEvent.BossBarColor.PURPLE : BossEvent.BossBarColor.RED);
            this.ticksSinceGuardianSeen = 0;
            if (!this.arenaOrigin.equals((Object)guardian.getArenaOrigin())) {
                guardian.setArenaOrigin(this.arenaOrigin);
                guardian.initPathPoints(true);
            }
            if (guardian.m_8077_()) {
                this.bossInfo.m_6456_(guardian.m_5446_());
            }
        }
    }

    private void cleanUpAndDispose() {
        ((ServerLevel)this.level).m_7726_().m_8438_(TicketType.f_9443_, new ChunkPos(this.arenaOrigin), 12, (Object)Unit.INSTANCE);
        this.bossInfo.m_7706_();
        this.removeEntity();
    }

    public UUID getGuardianUniqueId() {
        return this.guardianUniqueId;
    }

    public Collection<ServerPlayer> getTrackedPlayers() {
        return this.bossInfo.m_8324_();
    }

    private void findAliveCrystals() {
        this.ticksSinceCrystalsScanned = 0;
        this.aliveCrystals = 0;
        for (BlockPos pos : this.getCrystalPositions()) {
            List list = this.level.m_45976_(GuardianCrystalEntity.class, new AABB(pos.m_7918_(-3, -3, -3), pos.m_7918_(4, 4, 4)));
            for (GuardianCrystalEntity crystal : list) {
                if (!crystal.m_6084_()) continue;
                if (crystal.getManagerId() == null || !crystal.getManagerId().equals(this.getUniqueID())) {
                    crystal.setManagerId(this.getUniqueID());
                }
                ++this.aliveCrystals;
            }
        }
        this.bossInfo.setCrystals(this.getNumAliveCrystals());
        LOGGER.debug("Found {} end crystals still alive", (Object)this.aliveCrystals);
    }

    public void crystalSpawned() {
        ++this.aliveCrystals;
        this.bossInfo.setCrystals(this.getNumAliveCrystals());
    }

    public int getNumAliveCrystals() {
        return this.aliveCrystals;
    }

    public void onCrystalAttacked(GuardianCrystalEntity crystal, DamageSource dmgSrc, float damage, boolean destroyed) {
        Entity entity;
        ServerLevel world = (ServerLevel)this.level;
        if (destroyed) {
            this.findAliveCrystals();
        }
        if ((entity = world.m_8791_(this.guardianUniqueId)) instanceof DraconicGuardianEntity) {
            ((DraconicGuardianEntity)entity).onCrystalAttacked(crystal, crystal.m_20183_(), dmgSrc, damage, destroyed);
        }
    }

    public float getCrystalDamageModifier(GuardianCrystalEntity crystal, DamageSource dmgSrc) {
        if (dmgSrc.m_7639_() instanceof DraconicGuardianEntity) {
            crystal.destabilize();
            return 0.1f;
        }
        if (DEDamage.getDamageLevel(dmgSrc) == TechLevel.CHAOTIC && DEConfig.chaoticBypassCrystalShield) {
            crystal.destabilize();
            return 1.0f;
        }
        return crystal.getUnstableTime() > 0 ? 1.0f : 0.0f;
    }

    public boolean onGuardianAttacked(DraconicGuardianEntity guardian, DamageSource source, float damage) {
        return this.getNumAliveCrystals() == 0;
    }

    public void resetCrystals() {
        for (BlockPos pos : this.getCrystalPositions()) {
            for (GuardianCrystalEntity endercrystalentity : this.level.m_45976_(GuardianCrystalEntity.class, new AABB(pos.m_7918_(-3, -3, -3), pos.m_7918_(4, 4, 4)))) {
                endercrystalentity.m_20331_(false);
                endercrystalentity.setBeamTarget(null);
            }
        }
    }

    public List<GuardianCrystalEntity> getCrystals() {
        ArrayList<GuardianCrystalEntity> list = new ArrayList<GuardianCrystalEntity>();
        for (BlockPos pos : this.getCrystalPositions()) {
            list.addAll(this.level.m_45976_(GuardianCrystalEntity.class, new AABB(pos.m_7918_(-3, -3, -3), pos.m_7918_(4, 4, 4))));
        }
        return list;
    }

    public List<BlockPos> getCrystalPositions() {
        if (this.crystalsPosCache == null) {
            this.crystalsPosCache = new ArrayList<BlockPos>();
            for (int i = 0; i < 14; ++i) {
                double rotation = (double)i * 0.45;
                int sX = this.arenaOrigin.m_123341_() + (int)(Math.sin(rotation) * 90.0);
                int sZ = this.arenaOrigin.m_123343_() + (int)(Math.cos(rotation) * 90.0);
                this.crystalsPosCache.add(new BlockPos(sX, this.arenaOrigin.m_123342_() + 40, sZ));
            }
        }
        return this.crystalsPosCache;
    }

    public BlockPos getNextCrystalPos(boolean initial) {
        if (initial) {
            this.crystalSpawnList = new ArrayList<BlockPos>(this.getCrystalPositions());
        }
        if (this.crystalSpawnList.isEmpty()) {
            return null;
        }
        return this.crystalSpawnList.remove(0);
    }

    public BlockPos guardianSpawnPos() {
        return this.arenaOrigin.m_7918_(0, 80, 0);
    }

    public BlockPos getArenaOrigin() {
        return this.arenaOrigin;
    }

    public void write(CompoundTag nbt) {
        super.write(nbt);
        if (this.guardianUniqueId != null) {
            nbt.m_128362_("guardian", this.guardianUniqueId);
        }
        nbt.m_128379_("guardian_killed", this.guardianKilled);
        nbt.m_128365_("arena_origin", (Tag)NbtUtils.m_129224_((BlockPos)this.arenaOrigin));
        if (this.respawnState != null) {
            nbt.m_128379_("respawning", true);
        }
    }

    public void read(CompoundTag nbt) {
        super.read(nbt);
        if (nbt.m_128403_("guardian")) {
            this.guardianUniqueId = nbt.m_128342_("guardian");
        }
        this.guardianKilled = nbt.m_128471_("guardian_killed");
        this.arenaOrigin = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("arena_origin"));
        this.validPlayer = EntitySelector.f_20402_.and(EntitySelector.m_20410_((double)this.arenaOrigin.m_123341_(), (double)this.arenaOrigin.m_123342_(), (double)this.arenaOrigin.m_123343_(), (double)192.0));
        if (nbt.m_128471_("respawning")) {
            this.respawnState = GuardianSpawnState.START_WAIT_FOR_PLAYER;
        }
    }
}

