/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.handler;

import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.ProcessHandlerClient;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.lib.DelayedExecutor;
import com.brandon3055.draconicevolution.api.energy.ICrystalBinder;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.joml.Vector4f;

@Deprecated
public class ClientEventHandler {
    public static FloatBuffer winPos = FloatBuffer.allocate(3);
    public static volatile int elapsedTicks;
    public static boolean playerHoldingWrench;
    public static Minecraft mc;
    private static Random rand;
    public static BlockPos explosionPos;
    public static double explosionAnimation;
    public static int explosionTime;
    public static boolean explosionRetreating;
    public static final RenderType explosionFlashType;
    public static final Matrix4 MODELVIEW;
    public static final Matrix4 PROJECTION;

    public static void init() {
        mc = Minecraft.m_91087_();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(EventPriority.LOW, ClientEventHandler::registerOverlays);
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::tickEnd);
    }

    private static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("explosion_overlay", (gui, graphics, partialTick, screenWidth, screenHeight) -> {
            if (explosionPos != null) {
                ClientEventHandler.updateExplosionAnimation(mc, GuiRender.convert((GuiGraphics)graphics), mc.m_91268_(), mc.m_91296_());
            }
        });
    }

    public static void tickEnd(TickEvent.ClientTickEvent event) {
        LocalPlayer player;
        if (event.phase != TickEvent.Phase.END || event.type != TickEvent.Type.CLIENT || event.side != LogicalSide.CLIENT) {
            return;
        }
        ++elapsedTicks;
        if (explosionPos != null) {
            ClientEventHandler.updateExplosion();
        }
        if ((player = Minecraft.m_91087_().f_91074_) != null) {
            playerHoldingWrench = !player.m_21205_().m_41619_() && player.m_21205_().m_41720_() instanceof ICrystalBinder || !player.m_21206_().m_41619_() && player.m_21206_().m_41720_() instanceof ICrystalBinder;
        }
    }

    @SubscribeEvent
    public void renderPlayerEvent(RenderPlayerEvent.Post event) {
    }

    public static void triggerExplosionEffect(BlockPos pos, boolean reload) {
        explosionPos = pos;
        explosionRetreating = false;
        explosionAnimation = 0.0;
        explosionTime = 0;
        if (reload) {
            ProcessHandlerClient.addProcess((IProcess)new DelayedExecutor(13, new Object[0]){

                public void execute(Object[] args) {
                    Minecraft.m_91087_().f_91060_.m_109818_();
                }
            });
        }
    }

    private static void updateExplosion() {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        ++explosionTime;
        if (!explosionRetreating) {
            if ((explosionAnimation += 0.05) >= 1.0) {
                explosionAnimation = 1.0;
                explosionRetreating = true;
            }
        } else {
            if (explosionAnimation <= 0.0) {
                explosionAnimation = 0.0;
                explosionPos = null;
                return;
            }
            explosionAnimation -= 0.01;
        }
    }

    private static void updateExplosionAnimation(Minecraft mc, GuiRender render, Window window, float partialTick) {
        MultiBufferSource.BufferSource buffers = RenderUtils.getGuiBuffers();
        if (explosionRetreating) {
            float alpha = explosionAnimation <= 0.0 ? 0.0f : (explosionRetreating ? (float)explosionAnimation - partialTick * 0.01f : (float)explosionAnimation + partialTick * 0.05f);
            if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            render.rect(0.0, 0.0, (double)window.m_85445_(), (double)window.m_85446_(), 0xFFFFFF | (int)(alpha * 255.0f) << 24);
            RenderUtils.endBatch((MultiBufferSource)buffers);
        } else {
            Vec3 camPos = mc.f_91063_.m_109153_().m_90583_();
            Vector3 targetPos = Vector3.fromBlockPosCenter((BlockPos)explosionPos);
            targetPos.subtract(camPos.f_82479_, camPos.f_82480_, camPos.f_82481_);
            Vector3 winPos = ClientEventHandler.gluProject(targetPos, MODELVIEW, PROJECTION);
            boolean behind = winPos.z > 1.0;
            float screenX = behind ? -1.0f : (float)winPos.x / (float)window.m_85443_();
            float screenY = behind ? -1.0f : (float)winPos.y / (float)window.m_85444_();
            DEShaders.explosionFlashScreenPos.glUniform2f(screenX, screenY);
            DEShaders.explosionFlashIntensity.glUniform1f((float)explosionAnimation);
            DEShaders.explosionFlashScreenSize.glUniform2f((float)window.m_85443_(), (float)window.m_85444_());
            render.rect(explosionFlashType, 0.0, 0.0, (double)window.m_85445_(), (double)window.m_85446_(), -1);
            RenderUtils.endBatch((MultiBufferSource)buffers);
        }
    }

    private static Vector3 gluProject(Vector3 obj, Matrix4 modelMatrix, Matrix4 projMatrix) {
        Vector4f o = new Vector4f((float)obj.x, (float)obj.y, (float)obj.z, 1.0f);
        ClientEventHandler.multMatrix(modelMatrix, o);
        ClientEventHandler.multMatrix(projMatrix, o);
        if (o.w() == 0.0f) {
            return Vector3.ZERO.copy();
        }
        o.w = 1.0f / o.w() * 0.5f;
        o.x = o.x() * o.w() + 0.5f;
        o.y = o.y() * o.w() + 0.5f;
        o.z = o.z() * o.w() + 0.5f;
        Vector3 winPos = new Vector3();
        winPos.z = o.z();
        winPos.x = o.x() * (float)GlStateManager.Viewport.m_157128_();
        winPos.y = o.y() * (float)GlStateManager.Viewport.m_157129_();
        return winPos;
    }

    private static void multMatrix(Matrix4 mat, Vector4f vec) {
        double x = mat.m00 * (double)vec.x() + mat.m01 * (double)vec.y() + mat.m02 * (double)vec.z() + mat.m03 * (double)vec.w();
        double y = mat.m10 * (double)vec.x() + mat.m11 * (double)vec.y() + mat.m12 * (double)vec.z() + mat.m13 * (double)vec.w();
        double z = mat.m20 * (double)vec.x() + mat.m21 * (double)vec.y() + mat.m22 * (double)vec.z() + mat.m23 * (double)vec.w();
        double w = mat.m30 * (double)vec.x() + mat.m31 * (double)vec.y() + mat.m32 * (double)vec.z() + mat.m33 * (double)vec.w();
        vec.set((float)x, (float)y, (float)z, (float)w);
    }

    static {
        playerHoldingWrench = false;
        rand = new Random();
        explosionPos = null;
        explosionAnimation = 0.0;
        explosionTime = 0;
        explosionRetreating = false;
        explosionFlashType = RenderType.m_173209_((String)"draconicevolution:explosion_flash", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> DEShaders.explosionFlashShader)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));
        MODELVIEW = new Matrix4();
        PROJECTION = new Matrix4();
    }
}

