/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.effect.EffectTrackerCelestialManipulator;
import com.brandon3055.draconicevolution.client.sound.CelestialModifierSound;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.CelestialManipulatorMenu;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkHooks;

public class TileCelestialManipulator
extends TileBCore
implements IChangeListener,
MenuProvider,
IInteractTile {
    public final ManagedBool weatherMode = (ManagedBool)this.register((IManagedData)new ManagedBool("weather_mode", true, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool weatherToggleRunning = (ManagedBool)this.register((IManagedData)new ManagedBool("weather_toggle_running", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedBool timeWarpRunning = (ManagedBool)this.register((IManagedData)new ManagedBool("time_warp_running", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedBool timeWarpStopping = (ManagedBool)this.register((IManagedData)new ManagedBool("time_warp_stopping", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedBool redstoneSignal = (ManagedBool)this.register((IManagedData)new ManagedBool("redstone_signal", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte rsMode = (ManagedByte)this.register((IManagedData)new ManagedByte("rs_mode", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public int timer = 0;
    public boolean storm = false;
    public boolean rain = false;
    public long targetTime;
    public OPStorage opStorage = new ModularOPStorage(this, 8000000L, 4000000L, 4000000L);
    @OnlyIn(value=Dist.CLIENT)
    private CelestialModifierSound sound;
    @OnlyIn(value=Dist.CLIENT)
    private List<EffectTrackerCelestialManipulator> effects;
    private String[] ACTIONS = new String[]{"STOP_RAIN", "START_RAIN", "START_STORM", "SUN_RISE", "MID_DAY", "SUN_SET", "MOON_RISE", "MIDNIGHT", "MOON_SET", "SKIP_24"};

    public TileCelestialManipulator(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_CELESTIAL_MANIPULATOR.get(), pos, state);
        this.capManager.setManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.weatherMode.setCCSCS();
    }

    public void tick() {
        super.tick();
        if (this.weatherToggleRunning.get()) {
            ++this.timer;
            if (this.f_58857_.f_46443_) {
                this.updateWeatherEffects();
            } else if (this.timer >= 230) {
                this.timer = 0;
                this.weatherToggleRunning.set(false);
                this.f_58857_.m_6106_().m_5565_(this.rain);
                ((ServerLevelData)this.f_58857_.m_6106_()).m_5557_(this.storm);
                int time = 12000 + this.f_58857_.f_46441_.m_188503_(24000);
                ((ServerLevelData)this.f_58857_.m_6106_()).m_6399_(this.rain ? time : 0);
                ((ServerLevelData)this.f_58857_.m_6106_()).m_6393_(this.rain ? 0 : time);
            }
        } else if (this.timeWarpRunning.get()) {
            ++this.timer;
            if (this.f_58857_.f_46443_) {
                this.updateSunEffect();
            }
            if (this.timer > 100) {
                if (this.opStorage.getEnergyStored() > 320) {
                    int extracted = this.opStorage.extractEnergy(16000, true);
                    int ticks = extracted / 320;
                    if (this.f_58857_.f_46443_) {
                        ClientLevel cLevel = (ClientLevel)this.f_58857_;
                        cLevel.m_104746_(cLevel.m_46468_() + (long)ticks);
                    } else {
                        ServerLevel sLevel = (ServerLevel)this.f_58857_;
                        sLevel.m_8615_(sLevel.m_46468_() + (long)ticks);
                        this.opStorage.extractEnergy(ticks * 320, false);
                    }
                } else {
                    this.stopTimeWarp();
                }
                if (!this.f_58857_.f_46443_ && this.f_58857_.m_46468_() >= this.targetTime) {
                    this.stopTimeWarp();
                }
            }
        } else if (this.timeWarpStopping.get()) {
            if (this.timer > 100) {
                this.timer = 100;
            }
            --this.timer;
            if (this.timer <= 0 && !this.f_58857_.f_46443_) {
                this.timeWarpStopping.set(false);
            }
            if (this.f_58857_.f_46443_ && this.timer >= 0) {
                this.updateSunEffect();
            } else if (this.f_58857_.f_46443_) {
                if (this.effects != null) {
                    this.effects.clear();
                }
                if (this.sound != null) {
                    this.sound.kill();
                    this.sound = null;
                }
            }
        } else if (this.active.get()) {
            this.active.set(false);
        } else if (this.f_58857_.f_46443_) {
            this.standbyParticleEffect();
        }
    }

    public void toggleWeather(boolean rain, boolean storm) {
        if (this.f_58857_.f_46443_ || this.active.get()) {
            return;
        }
        this.storm = storm;
        this.rain = rain;
        this.timer = 0;
        this.weatherToggleRunning.set(true);
        this.active.set(true);
    }

    public void startTimeWarp(long targetTime) {
        this.active.set(true);
        this.targetTime = targetTime;
        this.timer = 0;
        this.timeWarpRunning.set(true);
    }

    public void stopTimeWarp() {
        this.timeWarpRunning.set(false);
        this.timeWarpStopping.set(true);
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        int intValue;
        if (id == 0) {
            this.handleInteract(data.readString(), (Player)client);
        } else if (id == 1 && (intValue = data.readInt()) >= 0 && intValue <= 9) {
            this.rsMode.set((int)((byte)intValue));
        }
    }

    public void handleInteract(String action, Player player) {
        if (action.endsWith("STOP") && this.active.get() && this.timeWarpRunning.get()) {
            this.stopTimeWarp();
            return;
        }
        if (this.active.get()) {
            this.sendMessage((Component)Component.m_237115_((String)"msg.draconicevolution.celestial_manipulator.alreadyRunning"), player);
            return;
        }
        switch (action) {
            case "STOP_RAIN": {
                if (!this.f_58857_.m_46471_()) {
                    this.sendMessage((Component)Component.m_237115_((String)"msg.draconicevolution.celestial_manipulator.notRaining"), player);
                    return;
                }
                if (this.opStorage.getEnergyStored() < 256000) {
                    this.sendMessage((Component)Component.m_237115_((String)"msg.draconicevolution.celestial_manipulator.insufficientPower").m_130946_(" (256000RF)"), player);
                    return;
                }
                this.opStorage.modifyEnergyStored(-256000L);
                this.toggleWeather(false, false);
                LogHelper.info("Stopped rain! Cause: " + String.valueOf(this.f_58858_));
                return;
            }
            case "START_RAIN": {
                if (this.f_58857_.m_46471_()) {
                    this.sendMessage((Component)Component.m_237115_((String)"msg.draconicevolution.celestial_manipulator.alreadyRaining"), player);
                    return;
                }
                if (this.opStorage.getEnergyStored() < 256000) {
                    this.sendMessage((Component)Component.m_237115_((String)"msg.draconicevolution.celestial_manipulator.insufficientPower").m_130946_(" (256000RF)"), player);
                    return;
                }
                this.opStorage.modifyEnergyStored(-256000L);
                this.toggleWeather(true, false);
                LogHelper.info("Started rain! Cause: " + String.valueOf(this.f_58858_));
                return;
            }
            case "START_STORM": {
                if (this.f_58857_.m_46471_() && this.f_58857_.m_46470_()) {
                    this.sendMessage((Component)Component.m_237115_((String)"msg.draconicevolution.celestial_manipulator.alreadyStorming"), player);
                    return;
                }
                if (this.opStorage.getEnergyStored() < 384000) {
                    this.sendMessage((Component)Component.m_237115_((String)"msg.draconicevolution.celestial_manipulator.insufficientPower").m_130946_(" (384000RF)"), player);
                    return;
                }
                this.opStorage.modifyEnergyStored(-384000L);
                this.toggleWeather(true, true);
                LogHelper.info("Started storm! Cause: " + String.valueOf(this.f_58858_));
                return;
            }
            case "SUN_RISE": {
                this.startTimeWarp(this.f_58857_.m_46468_() + (long)this.calculateTimeTill(0));
                LogHelper.info("Set time to sunrise! Cause: " + String.valueOf(this.f_58858_));
                break;
            }
            case "MID_DAY": {
                this.startTimeWarp(this.f_58857_.m_46468_() + (long)this.calculateTimeTill(5900));
                LogHelper.info("Set time to midday! Cause: " + String.valueOf(this.f_58858_));
                break;
            }
            case "SUN_SET": {
                this.startTimeWarp(this.f_58857_.m_46468_() + (long)this.calculateTimeTill(12000));
                LogHelper.info("Set time to sunset! Cause: " + String.valueOf(this.f_58858_));
                break;
            }
            case "MOON_RISE": {
                this.startTimeWarp(this.f_58857_.m_46468_() + (long)this.calculateTimeTill(13000));
                LogHelper.info("Set time to moonrise! Cause: " + String.valueOf(this.f_58858_));
                break;
            }
            case "MIDNIGHT": {
                this.startTimeWarp(this.f_58857_.m_46468_() + (long)this.calculateTimeTill(17900));
                LogHelper.info("Set time to midnight! Cause: " + String.valueOf(this.f_58858_));
                break;
            }
            case "MOON_SET": {
                this.startTimeWarp(this.f_58857_.m_46468_() + (long)this.calculateTimeTill(22500));
                LogHelper.info("Set time to moonset! Cause: " + String.valueOf(this.f_58858_));
                break;
            }
            case "SKIP_24": {
                this.startTimeWarp(this.f_58857_.m_46468_() + 24000L);
                LogHelper.info("Skipped one day! Cause: " + String.valueOf(this.f_58858_));
            }
        }
    }

    private void sendMessage(Component message, Player player) {
        if (player != null) {
            player.m_213846_(message);
        }
    }

    private int calculateTimeTill(int time) {
        int currentTime = (int)(this.f_58857_.m_46468_() % 24000L);
        return currentTime > time ? 24000 - (currentTime - time) : time - currentTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startWeatherEffect() {
        this.timer = 0;
        this.effects = new LinkedList<EffectTrackerCelestialManipulator>();
        for (int i = 0; i < 8; ++i) {
            this.effects.add(new EffectTrackerCelestialManipulator(this.f_58857_, Vec3D.getCenter((BlockPos)this.f_58858_).add(0.0, 1.5, 0.0), Vec3D.getCenter((BlockPos)this.f_58858_).add(0.0, 1.5, 0.0)));
        }
        Vec3D vec = Vec3D.getCenter((BlockPos)this.f_58858_.m_7918_(0, 1, 0));
        this.sound = new CelestialModifierSound((SoundEvent)DESounds.ELECTRIC_BUZZ.get(), this.f_58858_, this.f_58857_.f_46441_);
        this.sound.updateSound(vec, 0.01f, 0.5f);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.sound);
        this.f_58857_.m_7785_(vec.x, vec.y, vec.z, (SoundEvent)DESounds.FUSION_COMPLETE.get(), SoundSource.BLOCKS, this.getSoundVolume(), 0.5f, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateWeatherEffects() {
        int i;
        if (this.effects == null || this.effects.size() < 8 || this.sound == null) {
            this.startWeatherEffect();
            return;
        }
        double riseEnd = 20.0;
        double expandStart = 60.0;
        double expandEnd = 100.0;
        double ascendStart = 140.0;
        double ascendStop = 200.0;
        double ascendHeight = 500.0;
        double height = Math.min(riseEnd, (double)this.timer) / riseEnd * 3.0;
        double expansion = (double)this.timer > expandStart ? (Math.min(expandEnd, (double)this.timer) - expandStart) / (expandEnd - expandStart) : 0.0;
        double secondaryExpand = 0.0;
        double ascPos = 0.0;
        if ((double)this.timer > ascendStart) {
            ascPos = ((double)this.timer - ascendStart) / (ascendStop - ascendStart);
            height += ascPos * (ascendHeight * ascPos);
            secondaryExpand = ascPos * ascPos * 100.0;
        }
        Vec3D effectFocus = Vec3D.getCenter((BlockPos)this.f_58858_).add(0.0, height, 0.0);
        double scaleTime = ((double)this.timer - expandStart) / (ascendStart - expandStart);
        if ((double)this.timer > expandStart && (double)this.timer < ascendStart) {
            for (i = 0; i < 10; ++i) {
                Direction dir = Direction.values()[2 + this.f_58857_.f_46441_.m_188503_(4)];
                IntParticleType.IntParticleData data = new IntParticleType.IntParticleData((ParticleType)DEParticles.SPARK.get(), new int[]{0, 127, 255, (int)(1.0 * ((double)this.f_58857_.f_46441_.m_188501_() + 0.1) * 100.0), (int)(5.0 * scaleTime * 100.0), 10, 0, 0, 1000, 1});
                double speed = 0.03;
                Vector3 pos = Vector3.fromTileCenter((BlockEntity)this).add((double)dir.m_122429_() * -0.3, 0.0, (double)dir.m_122431_() * -0.3);
                this.f_58857_.m_7106_((ParticleOptions)data, pos.x, pos.y, pos.z, speed * (double)dir.m_122429_(), 0.0, speed * (double)dir.m_122431_());
            }
        }
        if ((double)this.timer == ascendStart) {
            for (i = 0; i < 100; ++i) {
                IntParticleType.IntParticleData data = new IntParticleType.IntParticleData((ParticleType)DEParticles.SPARK.get(), new int[]{0, 127, 255, (int)(5.0 * ((double)this.f_58857_.f_46441_.m_188501_() + 0.1) * 100.0), 10000, 80, 0, -500, 1000});
                Vector3 pos = Vector3.fromTileCenter((BlockEntity)this);
                this.f_58857_.m_7106_((ParticleOptions)data, pos.x, pos.y, pos.z, 0.5 * this.f_58857_.f_46441_.m_188583_(), 0.0, 0.5 * this.f_58857_.f_46441_.m_188583_());
            }
        }
        if ((double)this.timer != riseEnd && (double)this.timer == ascendStart) {
            this.f_58857_.m_7785_(effectFocus.x, effectFocus.y, effectFocus.z, (SoundEvent)DESounds.FUSION_COMPLETE.get(), SoundSource.BLOCKS, 1.0f, 2.0f, false);
            for (i = 0; i < 100; ++i) {
            }
        }
        this.sound.updateSound(effectFocus.copy().add(0.0, -(height * 0.8), 0.0), (float)expansion, (float)expansion + 0.5f);
        for (EffectTrackerCelestialManipulator effect : this.effects) {
            effect.onUpdate();
        }
        double rotation = (double)this.timer * (expansion * 0.05);
        for (EffectTrackerCelestialManipulator effect : this.effects) {
            effect.effectFocus = effectFocus;
            effect.scale = (float)expansion * (1.0f + (float)(ascPos * 5.0));
            double indexPos = (double)this.effects.indexOf(effect) / (double)this.effects.size();
            double offset = indexPos * (Math.PI * 2);
            double offsetX = Math.sin(rotation + offset) * expansion * (3.0 + secondaryExpand);
            double offsetZ = Math.cos(rotation + offset) * expansion * (3.0 + secondaryExpand);
            effect.pos = effectFocus.copy().add(offsetX, 0.0, offsetZ);
            offset = (indexPos + 1.0 / (double)this.effects.size()) * (Math.PI * 2);
            offsetX = Math.sin(rotation + offset) * expansion * (3.0 + secondaryExpand);
            offsetZ = Math.cos(rotation + offset) * expansion * (3.0 + secondaryExpand);
            effect.linkPos = effectFocus.copy().add(offsetX, 0.0, offsetZ);
        }
        if (this.timer >= 220) {
            this.f_58857_.m_7785_(effectFocus.x, effectFocus.y, effectFocus.z, (SoundEvent)DESounds.BOOM.get(), SoundSource.BLOCKS, DEOldConfig.disableLoudCelestialManipulator ? 1.0f : 100.0f, 1.0f, false);
            this.timer = 0;
            this.weatherToggleRunning.set(false);
            this.effects.clear();
            this.sound.kill();
            this.sound = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startSunEffect() {
        this.timeWarpRunning.set(true);
        this.timeWarpStopping.set(false);
        this.timer = 0;
        this.effects = new LinkedList<EffectTrackerCelestialManipulator>();
        for (int i = 0; i < 12; ++i) {
            this.effects.add(new EffectTrackerCelestialManipulator(this.f_58857_, Vec3D.getCenter((BlockPos)this.f_58858_).add(0.0, 1.5, 0.0), Vec3D.getCenter((BlockPos)this.f_58858_).add(0.0, 1.5, 0.0)));
        }
        this.effects.get((int)0).red = 1.0f;
        this.effects.get((int)0).green = 0.821f;
        this.effects.get((int)0).blue = 0.174f;
        this.effects.get((int)0).renderBolts = false;
        this.effects.get((int)1).red = 1.0f;
        this.effects.get((int)1).green = 1.0f;
        this.effects.get((int)1).blue = 1.0f;
        this.effects.get((int)1).renderBolts = false;
        this.sound = new CelestialModifierSound((SoundEvent)DESounds.SUN_DIAL_EFFECT.get(), this.f_58858_, this.f_58857_.f_46441_);
        this.sound.updateSound(Vec3D.getCenter((BlockPos)this.f_58858_), this.getSoundVolume(), 0.5f);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.sound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopSunEffect() {
        this.timeWarpRunning.set(false);
        this.timeWarpStopping.set(true);
        if (this.timer > 100) {
            this.timer = 100;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateSunEffect() {
        double offset;
        EffectTrackerCelestialManipulator effect;
        if (this.effects == null || this.effects.size() < 2 || this.sound == null) {
            this.startSunEffect();
        }
        double depProg = Math.min((double)((float)this.timer / 100.0f), 1.0);
        Vec3D focus = Vec3D.getCenter((BlockPos)this.f_58858_).add(0.0, 5.5 * depProg, 0.0);
        this.sound.updateSound(focus, (float)depProg, 0.5f + (float)depProg);
        IntParticleType.IntParticleData data = new IntParticleType.IntParticleData((ParticleType)DEParticles.SPARK.get(), new int[]{255, 127, 0, (int)((double)1.2f * ((double)this.f_58857_.f_46441_.m_188501_() + 0.1) * 100.0), 50, 30, 10, 0});
        Vector3 pos = Vector3.fromTileCenter((BlockEntity)this);
        this.f_58857_.m_7106_((ParticleOptions)data, pos.x, pos.y, pos.z, 0.002, 0.04, 0.002);
        Direction dir = Direction.values()[2 + this.f_58857_.f_46441_.m_188503_(4)];
        data = new IntParticleType.IntParticleData((ParticleType)DEParticles.SPARK.get(), new int[]{255, 127, 255, (int)(1.0 * ((double)this.f_58857_.f_46441_.m_188501_() + 0.1) * 100.0), 50, 10, 0, 0, 1000, 1});
        double speed = 0.03;
        pos = Vector3.fromTileCenter((BlockEntity)this).add((double)dir.m_122429_() * -0.3, 0.0, (double)dir.m_122431_() * -0.3);
        this.f_58857_.m_7106_((ParticleOptions)data, pos.x, pos.y, pos.z, speed * (double)dir.m_122429_(), 0.0, speed * (double)dir.m_122431_());
        double rotation = (double)(this.f_58857_.m_46468_() % 24000L) / 24000.0;
        for (int i = 0; i < 2; ++i) {
            effect = this.effects.get(i);
            effect.scale = (float)depProg;
            effect.onUpdate();
            offset = rotation * (Math.PI * 2);
            double offsetX = Math.cos(offset) * 2.5 * depProg;
            double offsetY = Math.sin(offset) * 2.5 * depProg;
            effect.pos = focus.copy().add(offsetX, offsetY, 0.0);
            rotation += 0.5;
            effect.effectFocus = focus;
        }
        rotation = (double)this.timer / 50.0;
        double inc = 1.0 / (double)(this.effects.size() - 2);
        for (int i = 2; i < this.effects.size(); ++i) {
            effect = this.effects.get(i);
            offset = rotation * (Math.PI * 2);
            double x = Math.cos(offset) * 1.0 * depProg;
            double z = Math.sin(offset) * 1.0 * depProg;
            effect.scale = (float)depProg;
            effect.onUpdate();
            effect.pos = focus.copy().add(x, (i % 2 == 0 ? x : -x) * 0.8, z);
            if (i % 2 == 0) {
                effect.red = 0.9f;
                effect.green = 0.5f;
                effect.blue = 0.1f;
            } else {
                effect.red = 0.3f;
                effect.green = 0.2f;
                effect.blue = 1.0f;
            }
            effect.effectFocus = focus;
            effect.renderBolts = false;
            rotation += inc;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void standbyParticleEffect() {
        IntParticleType.IntParticleData data = new IntParticleType.IntParticleData((ParticleType)DEParticles.SPARK.get(), new int[]{76, 0, 255, (int)((double)0.4f * ((double)this.f_58857_.f_46441_.m_188501_() + 0.1) * 100.0), 15, 30, 10, 0});
        Vector3 pos = Vector3.fromTileCenter((BlockEntity)this);
        this.f_58857_.m_7106_((ParticleOptions)data, pos.x, pos.y, pos.z, 0.002, 0.01, 0.002);
        if (this.effects != null) {
            this.effects = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderEffects(float partialTicks) {
        if (this.effects != null) {
            if (this.weatherToggleRunning.get()) {
                // empty if block
            }
            Tesselator tesselator = Tesselator.m_85913_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void onNeighborChange(BlockPos blockChanged) {
        if (this.f_58857_.m_276867_(this.f_58858_)) {
            if (!this.redstoneSignal.get()) {
                this.redstoneSignal.set(true);
                this.handleInteract(this.ACTIONS[this.rsMode.get()], null);
            }
        } else if (this.redstoneSignal.get()) {
            this.redstoneSignal.set(false);
            if (this.timeWarpRunning.get() && this.rsMode.get() == 9) {
                this.stopTimeWarp();
            }
        }
    }

    private float getSoundVolume() {
        return DEOldConfig.disableLoudCelestialManipulator ? 1.0f : 10.0f;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new CelestialManipulatorMenu(currentWindowIndex, player.m_150109_(), this);
    }

    public boolean onBlockActivated(BlockState state, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        }
        return true;
    }
}

