/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor;

import codechicken.lib.util.RotationUtils;
import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorInjector;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReactorComponent
extends EntityBlockBCore {
    private static final VoxelShape SHAPE_INJ_DOWN = Shapes.m_83048_((double)0.0, (double)0.885f, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_INJ_UP = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    private static final VoxelShape SHAPE_INJ_NORTH = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.885f, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_INJ_SOUTH = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.125);
    private static final VoxelShape SHAPE_INJ_WEST = Shapes.m_83048_((double)0.885f, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_INJ_EAST = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)1.0);
    private final boolean injector;

    public ReactorComponent(BlockBehaviour.Properties properties, boolean injector) {
        super(properties);
        this.injector = injector;
        this.setBlockEntity(() -> injector ? (BlockEntityType)DEContent.TILE_REACTOR_INJECTOR.get() : (BlockEntityType)DEContent.TILE_REACTOR_STABILIZER.get(), true);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileReactorInjector) {
            switch ((Direction)((TileReactorInjector)tile).facing.get()) {
                case DOWN: {
                    return SHAPE_INJ_DOWN;
                }
                case UP: {
                    return SHAPE_INJ_UP;
                }
                case NORTH: {
                    return SHAPE_INJ_NORTH;
                }
                case SOUTH: {
                    return SHAPE_INJ_SOUTH;
                }
                case WEST: {
                    return SHAPE_INJ_WEST;
                }
                case EAST: {
                    return SHAPE_INJ_EAST;
                }
            }
        }
        return super.m_5940_(state, world, pos, context);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        BlockEntity te = world.m_7702_(pos);
        Direction facing = RotationUtils.getPlacedRotation((BlockPos)pos, (LivingEntity)placer).m_122424_();
        if (te instanceof TileReactorComponent) {
            ((TileReactorComponent)te).facing.set((Enum)facing);
            ((TileReactorComponent)te).onPlaced();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileReactorComponent) {
            ((TileReactorComponent)te).onActivated(player);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TileReactorComponent) {
            ((TileReactorComponent)te).onBroken();
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof TileReactorComponent) {
            return ((TileReactorComponent)tileEntity).rsPower.get();
        }
        return 0;
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        level.m_5898_(player, 2001, pos, ReactorComponent.m_49956_((BlockState)state));
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        return true;
    }
}

