/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class PropertyProviderImpl
implements PropertyProvider {
    private UUID providerID = null;
    private String providerName;
    private Map<String, ConfigProperty> propertyMap = new HashMap<String, ConfigProperty>();

    public PropertyProviderImpl(String providerName) {
        this.providerName = providerName;
    }

    @Override
    public UUID getProviderID() {
        if (this.providerID == null) {
            this.regenProviderID();
        }
        return this.providerID;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public void regenProviderID() {
        this.providerID = UUID.randomUUID();
    }

    @Override
    public Collection<ConfigProperty> getProperties() {
        return this.propertyMap.values();
    }

    @Override
    @Nullable
    public ConfigProperty getProperty(String propertyID) {
        return this.propertyMap.get(propertyID);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("provider_id", this.getProviderID());
        CompoundTag properties = new CompoundTag();
        this.propertyMap.forEach((name, property) -> properties.m_128365_(name, (Tag)property.serializeNBT()));
        nbt.m_128365_("properties", (Tag)properties);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128403_("provider_id")) {
            this.providerID = nbt.m_128342_("provider_id");
        }
        CompoundTag properties = nbt.m_128469_("properties");
        this.propertyMap.forEach((name, property) -> property.deserializeNBT(properties.m_128469_(name)));
    }
}

