/*
 * Decompiled with CFR 0.152.
 */
package artifacts.world;

import artifacts.Artifacts;
import artifacts.entity.MimicEntity;
import artifacts.registry.ModEntityTypes;
import artifacts.registry.ModTags;
import artifacts.world.CampsiteFeatureConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class CampsiteFeature
extends Feature<CampsiteFeatureConfiguration> {
    public static final ResourceLocation CHEST_LOOT = Artifacts.id("chests/campsite_chest");
    public static final ResourceLocation BARREL_LOOT = Artifacts.id("chests/campsite_barrel");

    public CampsiteFeature() {
        super(CampsiteFeatureConfiguration.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<CampsiteFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        CampsiteFeatureConfiguration config = (CampsiteFeatureConfiguration)context.m_159778_();
        if (!this.isSufficientlyFlat(level, origin)) {
            return false;
        }
        BlockPos.m_121990_((BlockPos)origin.m_7918_(-2, 0, -2), (BlockPos)origin.m_7918_(2, 2, 2)).filter(pos -> Math.abs(pos.m_123341_() - origin.m_123341_()) < 2 || Math.abs(pos.m_123343_() - origin.m_123343_()) < 2).filter(pos -> !level.m_8055_(pos).m_60795_()).forEach(pos -> this.m_5974_((LevelWriter)level, (BlockPos)pos, Blocks.f_50627_.m_49966_()));
        this.placeFloor(config, level, origin, random);
        this.placeCampfire(config, level, origin, random);
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
        BlockPos pos2 = origin.m_5484_(direction, 2);
        if (random.m_188503_(3) == 0) {
            BlockPos.m_121990_((BlockPos)pos2.m_121945_(direction.m_122427_()), (BlockPos)pos2.m_121945_(direction.m_122428_())).forEach(barrelPos -> {
                this.placeBarrel(level, (BlockPos)barrelPos, random);
                if (random.m_188503_(3) == 0) {
                    this.placeBarrel(level, barrelPos.m_7494_(), random);
                }
            });
        } else {
            Direction bedDirection = random.m_188499_() ? direction.m_122427_() : direction.m_122428_();
            BlockState bedBlock = (BlockState)config.beds().m_213972_(random, pos2).m_61124_((Property)BedBlock.f_54117_, (Comparable)bedDirection);
            this.m_5974_((LevelWriter)level, pos2, (BlockState)bedBlock.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD));
            this.m_5974_((LevelWriter)level, pos2.m_121945_(bedDirection.m_122424_()), (BlockState)bedBlock.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.FOOT));
            this.placeBarrel(level, pos2.m_121945_(bedDirection), random);
            this.placeLightSource(config, level, pos2.m_121945_(bedDirection).m_7494_(), random);
        }
        direction = random.m_188499_() ? direction.m_122427_() : direction.m_122428_();
        pos2 = origin.m_5484_(direction, 2);
        List positions = BlockPos.m_121990_((BlockPos)pos2.m_121945_(direction.m_122427_()), (BlockPos)pos2.m_121945_(direction.m_122428_())).map(BlockPos::m_7949_).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(positions);
        this.placeCraftingStation(config, level, (BlockPos)positions.remove(0), random, direction.m_122424_());
        this.placeFurnace(config, level, (BlockPos)positions.remove(0), random, direction.m_122424_());
        this.placeChest(level, (BlockPos)positions.remove(0), random, direction.m_122424_());
        return true;
    }

    private boolean isSufficientlyFlat(WorldGenLevel level, BlockPos origin) {
        return BlockPos.m_121990_((BlockPos)origin.m_7918_(-2, 0, -2), (BlockPos)origin.m_7918_(2, 0, 2)).filter(pos -> level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)).filter(pos -> level.m_8055_(pos).m_60795_()).count() >= 6L;
    }

    private void placeFloor(CampsiteFeatureConfiguration config, WorldGenLevel level, BlockPos origin, RandomSource random) {
        BlockPos.m_121990_((BlockPos)origin.m_7918_(-2, -1, -2), (BlockPos)origin.m_7918_(2, -1, 2)).filter(pos -> Math.abs(pos.m_123341_() - origin.m_123341_()) < 2 || Math.abs(pos.m_123343_() - origin.m_123343_()) < 2).forEach(pos -> {
            if (!level.m_8055_(pos).m_60783_((BlockGetter)level, pos, Direction.UP)) {
                this.m_5974_((LevelWriter)level, (BlockPos)pos, config.floor().m_213972_(random, pos));
            } else if (random.m_188499_()) {
                if (level.m_8055_(pos).m_60713_(Blocks.f_152550_)) {
                    this.m_5974_((LevelWriter)level, (BlockPos)pos, Blocks.f_152551_.m_49966_());
                } else if (level.m_8055_(pos).m_60713_(Blocks.f_50069_)) {
                    this.m_5974_((LevelWriter)level, (BlockPos)pos, Blocks.f_50652_.m_49966_());
                }
            }
        });
    }

    private void placeCampfire(CampsiteFeatureConfiguration config, WorldGenLevel level, BlockPos origin, RandomSource random) {
        BlockState campfire = config.unlitCampfires().m_213972_(random, origin);
        if (Artifacts.CONFIG.common.campsite.allowLightSources && (double)random.m_188501_() < 0.1) {
            campfire = config.litCampfires().m_213972_(random, origin);
        }
        this.m_5974_((LevelWriter)level, origin, campfire);
    }

    private void placeLightSource(CampsiteFeatureConfiguration config, WorldGenLevel level, BlockPos pos, RandomSource random) {
        if ((double)random.m_188501_() < 0.5) {
            BlockState lightSource = config.unlitLightSources().m_213972_(random, pos);
            if (Artifacts.CONFIG.common.campsite.allowLightSources && (double)random.m_188501_() < 0.3) {
                lightSource = config.lightSources().m_213972_(random, pos);
            }
            this.m_5974_((LevelWriter)level, pos, lightSource);
        }
    }

    private void placeCraftingStation(CampsiteFeatureConfiguration config, WorldGenLevel level, BlockPos pos, RandomSource random, Direction facing) {
        BlockState craftingStation = config.craftingStations().m_213972_(random, pos);
        if (craftingStation.m_61138_((Property)BlockStateProperties.f_61374_)) {
            craftingStation = (BlockState)craftingStation.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
        }
        this.m_5974_((LevelWriter)level, pos, craftingStation);
        if (random.m_188503_(3) == 0) {
            this.m_5974_((LevelWriter)level, pos.m_7494_(), config.decorations().m_213972_(random, pos));
        }
    }

    private void placeFurnace(CampsiteFeatureConfiguration config, WorldGenLevel level, BlockPos pos, RandomSource random, Direction facing) {
        BlockState furnace = config.furnaces().m_213972_(random, pos);
        furnace = (BlockState)furnace.m_61124_((Property)FurnaceBlock.f_48683_, (Comparable)facing);
        this.m_5974_((LevelWriter)level, pos, furnace);
        if (random.m_188499_()) {
            this.m_5974_((LevelWriter)level, pos.m_7494_(), config.furnaceChimneys().m_213972_(random, pos));
        }
    }

    private void placeBarrel(WorldGenLevel level, BlockPos pos, RandomSource random) {
        BlockState barrel = Blocks.f_50618_.m_49966_();
        barrel = random.m_188499_() ? (BlockState)barrel.m_61124_((Property)BarrelBlock.f_49042_, (Comparable)Direction.UP) : (BlockState)barrel.m_61124_((Property)BarrelBlock.f_49042_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(random));
        this.m_5974_((LevelWriter)level, pos, barrel);
        RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)random, (BlockPos)pos, (ResourceLocation)BARREL_LOOT);
    }

    public void placeChest(WorldGenLevel level, BlockPos pos, RandomSource random, Direction facing) {
        if ((double)random.m_188501_() < Artifacts.CONFIG.common.campsite.getMimicChance()) {
            MimicEntity mimic = (MimicEntity)ModEntityTypes.MIMIC.get().m_20615_((Level)level.m_6018_());
            if (mimic != null) {
                mimic.setDormant(true);
                mimic.setFacing(facing);
                mimic.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                level.m_7967_((Entity)mimic);
            }
        } else {
            BlockState chest;
            if (random.m_188503_(8) == 0) {
                this.m_5974_((LevelWriter)level, pos.m_7495_(), Blocks.f_50077_.m_49966_());
                chest = Blocks.f_50325_.m_49966_();
                this.m_5974_((LevelWriter)level, pos, (BlockState)Blocks.f_50325_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(random)));
            } else {
                chest = Artifacts.CONFIG.common.campsite.useModdedChests ? ModTags.getTag(ModTags.CAMPSITE_CHESTS).m_213653_(random).map(Holder::m_203334_).orElse(Blocks.f_50087_).m_49966_() : Blocks.f_50087_.m_49966_();
            }
            if (chest.m_61138_((Property)BlockStateProperties.f_61374_)) {
                chest = (BlockState)chest.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
            }
            this.m_5974_((LevelWriter)level, pos, chest);
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)random, (BlockPos)pos, (ResourceLocation)CHEST_LOOT);
        }
    }
}

