/*
 * Decompiled with CFR 0.152.
 */
package artifacts.network;

import artifacts.component.SwimData;
import artifacts.platform.PlatformServices;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SwimPacket {
    private final boolean shouldSwim;

    public SwimPacket(FriendlyByteBuf buffer) {
        this.shouldSwim = buffer.readBoolean();
    }

    public SwimPacket(boolean shouldSwim) {
        this.shouldSwim = shouldSwim;
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.shouldSwim);
    }

    void apply(Supplier<NetworkManager.PacketContext> context) {
        Player player = context.get().getPlayer();
        if (player != null) {
            context.get().queue(() -> {
                SwimData swimData = PlatformServices.platformHelper.getSwimData((LivingEntity)player);
                if (swimData != null) {
                    swimData.setSwimming(this.shouldSwim);
                }
            });
        }
    }
}

