/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.item.wearable.chorustotem;

import artifacts.item.wearable.belt.ChorusTotemItem;
import artifacts.network.ChorusTotemUsedPacket;
import artifacts.network.NetworkHandler;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkTotemDeathProtection(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        Level level;
        LivingEntity entity = (LivingEntity)this;
        ItemStack totem = ChorusTotemItem.findTotem(entity);
        if (!totem.m_41619_() && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!damageSource.m_269533_(DamageTypeTags.f_268738_) && ModGameRules.CHORUS_TOTEM_TELEPORTATION_CHANCE.get() > entity.m_217043_().m_188500_()) {
                ChorusTotemItem.teleport(entity, level2);
                if (ModGameRules.CHORUS_TOTEM_DO_CONSUME_ON_USE.get().booleanValue()) {
                    totem.m_41774_(1);
                } else {
                    ModItems.CHORUS_TOTEM.get().addCooldown(entity, ModGameRules.CHORUS_TOTEM_COOLDOWN.get());
                }
                entity.m_21153_(Math.min(entity.m_21233_(), (float)Math.max(1, ModGameRules.CHORUS_TOTEM_HEALTH_RESTORED.get())));
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    entity.m_9236_().m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    NetworkHandler.CHANNEL.sendToPlayer(player, (Object)new ChorusTotemUsedPacket());
                }
                cir.setReturnValue((Object)true);
            }
        }
    }
}

