/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.necklace;

import artifacts.item.wearable.necklace.PendantItem;
import artifacts.registry.ModGameRules;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ThornPendantItem
extends PendantItem {
    public ThornPendantItem() {
        super(ModGameRules.THORN_PENDANT_STRIKE_CHANCE, ModGameRules.THORN_PENDANT_COOLDOWN);
    }

    @Override
    public boolean hasNonCosmeticEffects() {
        return super.hasNonCosmeticEffects() && ModGameRules.THORN_PENDANT_MAX_DAMAGE.get() > 0;
    }

    @Override
    protected void applyEffect(LivingEntity target, LivingEntity attacker) {
        if (attacker.m_5789_()) {
            int damage;
            int minDamage = ModGameRules.THORN_PENDANT_MIN_DAMAGE.get();
            int maxDamage = ModGameRules.THORN_PENDANT_MAX_DAMAGE.get();
            if (maxDamage < minDamage) {
                minDamage = maxDamage;
            }
            if ((damage = minDamage + target.m_217043_().m_188503_(maxDamage - minDamage + 1)) > 0) {
                attacker.m_6469_(target.m_269291_().m_269374_((Entity)target), (float)damage);
            }
        }
    }
}

