/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.core.common.inventory.IContainerCallback;

public class InventoryInternal
implements Container,
Nameable {
    protected final ItemStack[] contents;
    private final String saveName;
    private final int stackLimit;
    private final BlockEntity invOwner;
    private final String displayNameKey;
    private final Component displayName;
    private final IContainerCallback callback;

    public InventoryInternal(BlockEntity invOwner, String saveName, int invSize, String displayName) {
        this(invOwner, saveName, invSize, 0, displayName);
    }

    public InventoryInternal(BlockEntity invOwner, String saveName, int invSize, String displayName, IContainerCallback callback) {
        this(invOwner, saveName, invSize, 0, displayName, invOwner instanceof IContainerCallback ? (IContainerCallback)invOwner : null);
    }

    public InventoryInternal(BlockEntity invOwner, String saveName, int invSize, int invStackLimit, String displayName) {
        this(invOwner, saveName, invSize, invStackLimit, displayName, invOwner instanceof IContainerCallback ? (IContainerCallback)invOwner : null);
    }

    public InventoryInternal(BlockEntity invOwner, String saveName, int invSize, int invStackLimit, String displayName, IContainerCallback callback) {
        this.contents = new ItemStack[invSize];
        this.invOwner = invOwner;
        this.saveName = saveName;
        this.stackLimit = invStackLimit;
        this.displayNameKey = displayName;
        this.displayName = Component.m_237115_((String)this.displayNameKey);
        this.callback = callback;
        this.m_6211_();
    }

    public void writeToNBT(CompoundTag nbtTag) {
        this.writeToNBT(nbtTag, this.saveName);
    }

    public void writeToNBT(CompoundTag nbtTag, String name) {
        ListTag listStacks = new ListTag();
        for (int index = 0; index < Math.min(this.contents.length, 256); index = (int)((short)(index + 1))) {
            if (this.contents[index].m_41619_()) continue;
            CompoundTag entry = new CompoundTag();
            entry.m_128344_("slot", (byte)index);
            this.contents[index].m_41739_(entry);
            listStacks.add((Object)entry);
        }
        nbtTag.m_128365_(name, (Tag)listStacks);
    }

    public void readFromNBT(CompoundTag nbtTag) {
        this.readFromNBT(nbtTag, this.saveName);
    }

    public void readFromNBT(CompoundTag nbtTag, String name) {
        this.m_6211_();
        ListTag listStacks = nbtTag.m_128437_(name, 10);
        for (int index = 0; index < listStacks.size(); index = (int)((short)(index + 1))) {
            CompoundTag entry = listStacks.m_128728_(index);
            int slot = (entry.m_128441_("slot") ? entry.m_128445_("slot") : entry.m_128445_("Slot")) & 0xFF;
            if (!this.okSlotId(index)) continue;
            this.contents[slot] = ItemStack.m_41712_((CompoundTag)entry);
        }
    }

    public ItemStack[] getContents() {
        return this.contents;
    }

    protected boolean okSlotId(int slotId) {
        return slotId > -1 && slotId < this.contents.length;
    }

    public String getNameKey() {
        return this.displayNameKey;
    }

    public int m_6643_() {
        return this.contents.length;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int slotId) {
        return this.okSlotId(slotId) ? this.contents[slotId] : ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack m_7407_(int slotId, int amount) {
        if (this.okSlotId(slotId) && !this.contents[slotId].m_41619_()) {
            if (this.contents[slotId].m_41613_() > amount) {
                ItemStack result = this.contents[slotId].m_41620_(amount);
                this.m_6596_();
                return result;
            }
            ItemStack stack = this.contents[slotId];
            this.m_6836_(slotId, ItemStack.f_41583_);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack m_8016_(int slotId) {
        ItemStack returnStack = this.m_8020_(slotId);
        this.m_6836_(slotId, ItemStack.f_41583_);
        return returnStack;
    }

    public void m_6836_(int slotId, @Nonnull ItemStack stack) {
        if (this.okSlotId(slotId)) {
            this.contents[slotId] = stack;
            if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
                stack.m_41764_(this.m_6893_());
            }
            this.m_6596_();
        }
    }

    public int m_6893_() {
        return this.stackLimit < 1 ? super.m_6893_() : this.stackLimit;
    }

    public void m_6596_() {
        if (this.invOwner != null) {
            this.invOwner.m_6596_();
        }
        if (this.callback != null) {
            this.callback.onInventoryChange(this.invOwner, this);
        }
    }

    public boolean inReachOf(Player player) {
        return this.invOwner == null || player.m_20275_((double)this.invOwner.m_58899_().m_123341_() + 0.5, (double)this.invOwner.m_58899_().m_123342_() + 0.5, (double)this.invOwner.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    public boolean blockUnchanged() {
        if (this.invOwner != null) {
            if (!this.invOwner.m_58901_()) {
                Level world = this.invOwner.m_58904_();
                return world != null && world.m_7702_(this.invOwner.m_58899_()) == this.invOwner;
            }
            return false;
        }
        return true;
    }

    public boolean m_6542_(Player player) {
        boolean original;
        boolean bl = original = this.invOwner != null && this.blockUnchanged() && this.inReachOf(player);
        if (this.callback != null) {
            return this.callback.canInteractWith(this.invOwner, this, player, original);
        }
        return original;
    }

    public void m_5856_(Player player) {
        if (this.callback != null) {
            this.callback.onContainerOpen(this.invOwner, this, player);
        }
    }

    public void m_5785_(Player player) {
        if (this.callback != null) {
            this.callback.onContainerClosed(this.invOwner, this, player);
        }
    }

    public boolean m_7013_(int slotId, @Nonnull ItemStack stack) {
        return this.okSlotId(slotId);
    }

    public void m_6211_() {
        for (int slot = 0; slot < this.contents.length; ++slot) {
            this.contents[slot] = ItemStack.f_41583_;
        }
    }

    public Component m_7755_() {
        return this.displayName;
    }

    public boolean m_8077_() {
        return false;
    }

    @Nullable
    public Component m_7770_() {
        return null;
    }
}

