/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type;

import java.util.HashMap;
import java.util.Map;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.AssocTypeID;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.FunctionTypeID;
import org.openzen.zenscript.codemodel.type.GenericMapTypeID;
import org.openzen.zenscript.codemodel.type.GenericTypeID;
import org.openzen.zenscript.codemodel.type.InvalidTypeID;
import org.openzen.zenscript.codemodel.type.IteratorTypeID;
import org.openzen.zenscript.codemodel.type.OptionalTypeID;
import org.openzen.zenscript.codemodel.type.RangeTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.TypeVisitorWithContext;
import org.openzen.zenscript.codemodel.type.member.LocalMemberCache;

public class TypeMatcher
implements TypeVisitorWithContext<Matching, Boolean, RuntimeException> {
    private static final TypeMatcher INSTANCE = new TypeMatcher();

    private TypeMatcher() {
    }

    public static Map<TypeParameter, TypeID> match(LocalMemberCache cache, TypeID type, TypeID pattern) {
        Matching matching = new Matching(cache, type);
        if (pattern.accept(matching, INSTANCE).booleanValue()) {
            return matching.mapping;
        }
        return null;
    }

    @Override
    public Boolean visitBasic(Matching context, BasicTypeID basic) {
        return context.type == basic;
    }

    @Override
    public Boolean visitArray(Matching context, ArrayTypeID array) {
        if (context.type instanceof ArrayTypeID) {
            ArrayTypeID arrayType = (ArrayTypeID)context.type;
            if (arrayType.dimension != array.dimension) {
                return false;
            }
            return this.match(context, arrayType.elementType, array.elementType);
        }
        return false;
    }

    @Override
    public Boolean visitAssoc(Matching context, AssocTypeID assoc) {
        if (context.type instanceof AssocTypeID) {
            AssocTypeID assocType = (AssocTypeID)context.type;
            return this.match(context, assocType.keyType, assoc.keyType) && this.match(context, assocType.valueType, assoc.valueType);
        }
        return false;
    }

    @Override
    public Boolean visitInvalid(Matching context, InvalidTypeID invalid) {
        return false;
    }

    @Override
    public Boolean visitIterator(Matching context, IteratorTypeID iterator) {
        if (context.type instanceof IteratorTypeID) {
            IteratorTypeID iteratorType = (IteratorTypeID)context.type;
            if (iteratorType.iteratorTypes.length != iterator.iteratorTypes.length) {
                return false;
            }
            boolean result = true;
            for (int i = 0; i < iteratorType.iteratorTypes.length; ++i) {
                result = result && this.match(context, iterator.iteratorTypes[i], iteratorType.iteratorTypes[i]);
            }
            return result;
        }
        return false;
    }

    @Override
    public Boolean visitFunction(Matching context, FunctionTypeID function) {
        if (context.type instanceof FunctionTypeID) {
            FunctionTypeID functionType = (FunctionTypeID)context.type;
            if (functionType.header.parameters.length != function.header.parameters.length) {
                return false;
            }
            if (!this.match(context, functionType.header.getReturnType(), function.header.getReturnType())) {
                return false;
            }
            for (int i = 0; i < function.header.parameters.length; ++i) {
                if (this.match(context, functionType.header.parameters[i].type, function.header.parameters[i].type)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitDefinition(Matching context, DefinitionTypeID definition) {
        if (context.type instanceof DefinitionTypeID) {
            DefinitionTypeID definitionType = (DefinitionTypeID)context.type;
            if (definitionType.definition != definition.definition) {
                return false;
            }
            if (definition.typeArguments != null) {
                for (int i = 0; i < definitionType.typeArguments.length; ++i) {
                    if (this.match(context, definitionType.typeArguments[i], definition.typeArguments[i])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitGeneric(Matching context, GenericTypeID generic) {
        if (context.mapping.containsKey(generic.parameter)) {
            TypeID argument = context.mapping.get(generic.parameter);
            return argument == context.type;
        }
        if (context.type == generic || generic.matches(context.cache, context.type)) {
            context.mapping.put(generic.parameter, context.type);
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitRange(Matching context, RangeTypeID range) {
        if (context.type instanceof RangeTypeID) {
            RangeTypeID rangeType = (RangeTypeID)context.type;
            return this.match(context, rangeType.baseType, range.baseType);
        }
        return false;
    }

    @Override
    public Boolean visitOptional(Matching context, OptionalTypeID type) {
        if (context.type instanceof OptionalTypeID) {
            OptionalTypeID modified = (OptionalTypeID)context.type;
            return this.match(context, modified.baseType, type.baseType);
        }
        return false;
    }

    private boolean match(Matching context, TypeID type, TypeID pattern) {
        return pattern.accept(context.withType(type), this);
    }

    @Override
    public Boolean visitGenericMap(Matching context, GenericMapTypeID map) {
        return map == context.type;
    }

    public static final class Matching {
        public final LocalMemberCache cache;
        public final TypeID type;
        public final Map<TypeParameter, TypeID> mapping;

        public Matching(LocalMemberCache cache, TypeID type) {
            this.cache = cache;
            this.type = type;
            this.mapping = new HashMap<TypeParameter, TypeID>();
        }

        private Matching(LocalMemberCache cache, TypeID type, Map<TypeParameter, TypeID> mapping) {
            this.cache = cache;
            this.type = type;
            this.mapping = mapping;
        }

        public Matching withType(TypeID type) {
            return new Matching(this.cache, type, this.mapping);
        }
    }
}

