/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.registry;

import com.blamejared.crafttweaker.api.zencode.IScriptLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class LoaderRegistry {
    private final Map<String, IScriptLoader> loaders = new HashMap<String, IScriptLoader>();

    LoaderRegistry() {
    }

    void registerLoaders(Collection<IScriptLoader> loaders) {
        if (!this.loaders.isEmpty()) {
            throw new IllegalStateException("Loaders have already been registered");
        }
        loaders.stream().filter(it -> !"*".equals(it.name())).forEach(it -> this.loaders.put(it.name(), (IScriptLoader)it));
    }

    IScriptLoader find(String name) {
        return this.loaders.computeIfAbsent(name, it -> {
            throw new IllegalArgumentException("No loader with name '" + it + "' registered; are you too early?");
        });
    }

    Collection<IScriptLoader> getAllLoaders() {
        return Collections.unmodifiableCollection(this.loaders.values());
    }
}

