/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.regex.Pattern;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class LootTableIdRegexCondition
implements LootItemCondition {
    public static final LootItemConditionType LOOT_TABLE_ID_REGEX = new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    private final Pattern regex;

    private LootTableIdRegexCondition(Pattern regex) {
        this.regex = regex;
    }

    public static LootItemCondition.Builder builder(Pattern regex) {
        return () -> new LootTableIdRegexCondition(regex);
    }

    public static LootItemCondition.Builder builder(String regex) {
        return LootTableIdRegexCondition.builder(Pattern.compile(regex));
    }

    public LootItemConditionType m_7940_() {
        return LOOT_TABLE_ID_REGEX;
    }

    public boolean test(LootContext context) {
        return this.regex.matcher(context.getQueriedLootTableId().toString()).matches();
    }

    public static final class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LootTableIdRegexCondition> {
        public void serialize(JsonObject pJson, LootTableIdRegexCondition pValue, JsonSerializationContext pSerializationContext) {
            pJson.addProperty("regex", pValue.regex.toString());
        }

        public LootTableIdRegexCondition deserialize(JsonObject pJson, JsonDeserializationContext pSerializationContext) {
            return new LootTableIdRegexCondition(Pattern.compile(GsonHelper.m_13906_((JsonObject)pJson, (String)"regex")));
        }
    }
}

