/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type.script.example;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.impl.command.type.script.example.ResourceManagerSourceFile;
import com.blamejared.crafttweaker.mixin.common.access.server.AccessMinecraftServer;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import org.apache.commons.io.input.ReaderInputStream;
import org.openzen.zencode.shared.SourceFile;

public final class ExamplesCommand {
    private ExamplesCommand() {
    }

    public static void registerCommand(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("examples", Component.m_237115_((String)"crafttweaker.command.description.examples"), builder -> ((LiteralArgumentBuilder)builder.requires(source -> source.m_6761_(2))).executes(ctx -> ExamplesCommand.execute(((CommandSourceStack)ctx.getSource()).m_81375_())));
    }

    private static int execute(ServerPlayer player) {
        MinecraftServer server = player.f_8924_;
        MinecraftServer.ReloadableResources reloadableResources = ((AccessMinecraftServer)server).crafttweaker$getResources();
        CloseableResourceManager resourceManager = reloadableResources.f_206584_();
        int examplesAmount = resourceManager.m_214159_("scripts", n -> n.m_135815_().endsWith(".zs")).entrySet().stream().map(ResourceManagerSourceFile::new).mapToInt(ExamplesCommand::writeScriptFile).sum();
        player.m_213846_(CommandUtilities.openingFile(Component.m_237115_((String)"crafttweaker.command.example.generated").m_130940_(ChatFormatting.GREEN), ExamplesCommand.getExamplesDir().toString()));
        return examplesAmount;
    }

    private static int writeScriptFile(SourceFile sourceFile) {
        Path file = ExamplesCommand.getExamplesDir().resolve(sourceFile.getFilename());
        if (Files.exists(file, new LinkOption[0])) {
            CommandUtilities.COMMAND_LOGGER.info("Skip writing example file '{}' since it already exists", (Object)file);
            return 0;
        }
        if (!Files.exists(file.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                CommandUtilities.COMMAND_LOGGER.error("Could not create folder '" + file.getParent() + "'", (Throwable)e);
                return 0;
            }
        }
        try (Reader reader = sourceFile.open();
             ReaderInputStream readerStream = new ReaderInputStream(reader, StandardCharsets.UTF_8);
             NoLoadInjectingInputStream stream = new NoLoadInjectingInputStream((InputStream)readerStream, StandardCharsets.UTF_8, "\n");){
            Files.copy(stream, file, new CopyOption[0]);
        }
        catch (IOException e) {
            CommandUtilities.COMMAND_LOGGER.warn("Could not write script example: ", (Throwable)e);
        }
        return 1;
    }

    private static Path getExamplesDir() {
        return CraftTweakerAPI.getScriptsDirectory().resolve("./examples");
    }

    private static final class NoLoadInjectingInputStream
    extends InputStream {
        private static final int EOF = -1;
        private static final byte INPUT_SOURCE_DELEGATE = 0;
        private static final byte INPUT_SOURCE_BYTE = 1;
        private static final byte INPUT_SOURCE_END = 2;
        private static final String INJECTED_STRING = "#noload\n// The line above will prevent the script from running, ensuring examples do not affect your current setup.\n// Feel free to comment or remove the line if you want to see a particular example in action.\n";
        private final InputStream delegate;
        private final ByteBuffer next;
        private boolean open;
        private byte inputSource;

        NoLoadInjectingInputStream(InputStream delegate, Charset charset, String lineEndings) {
            this.delegate = delegate;
            this.next = NoLoadInjectingInputStream.computeNext(charset, lineEndings);
            this.open = true;
            this.inputSource = 0;
        }

        private static ByteBuffer computeNext(Charset charset, String lineEndings) {
            String replaced = lineEndings + INJECTED_STRING.replace("\n", lineEndings);
            ByteBuffer encoded = charset.encode(replaced);
            ByteBuffer result = ByteBuffer.allocate(encoded.remaining());
            result.put(encoded);
            result.flip();
            return result;
        }

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            if (this.inputSource == 0) {
                int delegate = this.delegate.read();
                if (delegate != -1) {
                    return delegate;
                }
                this.inputSource = 1;
            }
            if (this.inputSource == 1) {
                try {
                    return this.next.get() & 0xFF;
                }
                catch (BufferUnderflowException e) {
                    this.inputSource = (byte)2;
                }
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            this.next.clear();
            this.open = false;
        }

        private void ensureOpen() throws IOException {
            if (!this.open) {
                throw new IOException("Stream closed");
            }
        }
    }
}

