/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util.sequence.task.type;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.util.sequence.SequenceContext;
import com.blamejared.crafttweaker.api.util.sequence.task.ISequenceTask;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/sequence/task/type/InstantTask")
@ZenCodeType.Name(value="crafttweaker.api.sequence.task.type.InstantTask")
public class InstantTask<T, U>
implements ISequenceTask<T, U> {
    private final BiConsumer<T, SequenceContext<T, U>> actorConsumer;
    private boolean complete = false;

    @ZenCodeType.Constructor
    public InstantTask(Consumer<T> actorConsumer) {
        this.actorConsumer = (actor, context) -> actorConsumer.accept(actor);
    }

    @ZenCodeType.Constructor
    public InstantTask(BiConsumer<T, SequenceContext<T, U>> actorConsumer) {
        this.actorConsumer = actorConsumer;
    }

    @Override
    public void tick(T actor, SequenceContext<T, U> data) {
        this.actorConsumer.accept(actor, data);
        this.complete = true;
    }

    @Override
    public boolean isComplete(T actor, SequenceContext<T, U> data) {
        return this.complete;
    }
}

