/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement;

import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.replacement.DescriptivePredicate;
import com.blamejared.crafttweaker.api.recipe.replacement.DescriptiveUnaryOperator;
import com.blamejared.crafttweaker.api.recipe.replacement.ITargetingStrategy;
import java.util.ArrayList;
import java.util.List;

public record ReplacementRequest<T>(IRecipeComponent<T> component, ITargetingStrategy strategy, DescriptivePredicate<T> target, DescriptiveUnaryOperator<T> replacer) {
    public boolean applyRequest(IDecomposedRecipe recipe) {
        List<T> object = recipe.get(this.component());
        if (object == null || object.isEmpty()) {
            return false;
        }
        ArrayList<T> newList = new ArrayList<T>(object);
        boolean replaced = this.applyToEach(newList);
        if (replaced) {
            recipe.set(this.component(), newList);
        }
        return replaced;
    }

    public String describe() {
        return "replacing component %s matching %s according to %s with %s".formatted(this.component().getCommandString(), this.target().describe(), this.strategy().getCommandString(), this.replacer().describe());
    }

    private boolean applyToEach(List<T> elements) {
        boolean any = false;
        int s = elements.size();
        for (int i = 0; i < s; ++i) {
            T old = elements.get(i);
            T replaced = this.tryToReplace(old);
            if (replaced == null) continue;
            any = true;
            elements.set(i, replaced);
        }
        return any;
    }

    private T tryToReplace(T object) {
        return (T)this.strategy().castStrategy(this.component(), object, this::replace);
    }

    private T replace(T object) {
        return this.target().test(object) ? (T)this.replacer().apply(object) : null;
    }
}

