/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.transform.type;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.transform.IIngredientTransformer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformDamageSerializer;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.world.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.ingredient.transform.type.TransformDamage")
@Document(value="vanilla/api/ingredient/transform/type/TransformDamage")
public class TransformDamage<T extends IIngredient>
implements IIngredientTransformer<T> {
    private final int amount;

    public TransformDamage(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public IItemStack transform(IItemStack stack) {
        ItemStack internal = stack.getImmutableInternal();
        int newDamage = internal.m_41773_() + this.amount;
        if (internal.m_41776_() < newDamage) {
            return IItemStack.empty();
        }
        internal.m_41721_(newDamage);
        return IItemStack.of(internal.m_41777_());
    }

    @Override
    public String getCommandString(T transformedIngredient) {
        if (this.amount == 1) {
            return transformedIngredient.getCommandString() + ".transformDamage()";
        }
        return String.format("%s.transformDamage(%s)", transformedIngredient.getCommandString(), this.amount);
    }

    @Override
    public IIngredientTransformerSerializer getSerializer() {
        return TransformDamageSerializer.INSTANCE;
    }
}

