/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.ByteData;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.visitor.DataVisitor;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Objects;
import net.minecraft.nbt.ByteTag;
import org.jetbrains.annotations.NotNull;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.BoolData")
@ZenRegister
@Document(value="vanilla/api/data/BoolData")
public class BoolData
implements IData {
    public static final BoolData TRUE = new BoolData(true);
    public static final BoolData FALSE = new BoolData(false);
    private final boolean internalValue;
    private final ByteData internalData;

    @ZenCodeType.Constructor
    public BoolData(boolean internalValue) {
        this.internalValue = internalValue;
        this.internalData = new ByteData(ByteTag.m_128273_((boolean)this.asBool()));
    }

    @ZenCodeType.Caster
    @ZenCodeType.Method
    public ByteData getByteData() {
        return new ByteData(ByteTag.m_128273_((boolean)this.asBool()));
    }

    public ByteTag getInternal() {
        return this.internalData.getInternal();
    }

    @Override
    public IData or(IData other) {
        return this.of(this.asBool() | other.asBool());
    }

    @Override
    public IData and(IData other) {
        return this.of(this.asBool() & other.asBool());
    }

    @Override
    public IData xor(IData other) {
        return this.of(this.asBool() ^ other.asBool());
    }

    @Override
    public IData not() {
        return this.of(!this.asBool());
    }

    @Override
    public boolean contains(IData other) {
        return other.asBool() == this.asBool();
    }

    @Override
    public int compareTo(@NotNull IData other) {
        return Boolean.compare(this.asBool(), other.asBool());
    }

    @Override
    public boolean equalTo(IData other) {
        return this.asBool() == other.asBool();
    }

    @Override
    public byte asByte() {
        return (byte)this.asInt();
    }

    @Override
    public short asShort() {
        return (short)this.asInt();
    }

    @Override
    public int asInt() {
        return this.asBool() ? 1 : 0;
    }

    @Override
    public long asLong() {
        return this.asInt();
    }

    @Override
    public float asFloat() {
        return this.asInt();
    }

    @Override
    public double asDouble() {
        return this.asInt();
    }

    @Override
    @ZenCodeType.Caster(implicit=true)
    public boolean asBool() {
        return this.internalValue;
    }

    @Override
    public IData copy() {
        return this.of(this.asBool());
    }

    @Override
    public IData copyInternal() {
        return this.copy();
    }

    @Override
    public <T> T accept(DataVisitor<T> visitor) {
        return visitor.visitBool(this);
    }

    @Override
    public IData.Type getType() {
        return IData.Type.BOOL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoolData boolData = (BoolData)o;
        return this.internalValue == boolData.internalValue;
    }

    public int hashCode() {
        return Objects.hash(this.internalValue);
    }

    private BoolData of(boolean value) {
        return value ? TRUE : FALSE;
    }

    public String toString() {
        return this.getAsString();
    }
}

