/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import owmii.powah.block.cable.CableTile;

public class CableNet {
    private static final Logger LOG = LoggerFactory.getLogger(CableNet.class);
    private static final Map<Level, Long2ObjectMap<Long2ObjectMap<CableTile>>> loadedCables = new WeakHashMap<Level, Long2ObjectMap<Long2ObjectMap<CableTile>>>();
    List<CableTile> cableList;

    static void addCable(CableTile cable) {
        long chunkPos = ChunkPos.m_151388_((BlockPos)cable.m_58899_());
        CableTile previousCable = (CableTile)((Long2ObjectMap)loadedCables.computeIfAbsent(cable.m_58904_(), l -> new Long2ObjectOpenHashMap()).computeIfAbsent(chunkPos, l -> new Long2ObjectOpenHashMap())).put(cable.m_58899_().m_121878_(), (Object)cable);
        if (previousCable != null) {
            throw new RuntimeException("Cable added to position %s, but there was already one there?".formatted(cable.m_58899_()));
        }
        CableNet.updateAdjacentCables(cable);
    }

    static void removeCable(CableTile cable) {
        Level level = cable.m_58904_();
        if (level == null) {
            return;
        }
        Long2ObjectMap<Long2ObjectMap<CableTile>> levelMap = loadedCables.get(level);
        if (levelMap == null) {
            return;
        }
        BlockPos blockPos = cable.m_58899_();
        long chunkPos = ChunkPos.m_151388_((BlockPos)blockPos);
        Long2ObjectMap chunkMap = (Long2ObjectMap)levelMap.get(chunkPos);
        if (chunkMap == null) {
            return;
        }
        if (chunkMap.remove(blockPos.m_121878_()) != cable) {
            throw new RuntimeException("Removed wrong cable from position %s".formatted(blockPos));
        }
        if (chunkMap.isEmpty()) {
            levelMap.remove(chunkPos);
        }
        if (levelMap.isEmpty()) {
            loadedCables.remove(level);
        }
        CableNet.updateAdjacentCables(cable);
    }

    @Nullable
    private static CableTile getCableAt(Long2ObjectMap<Long2ObjectMap<CableTile>> levelMap, BlockPos pos) {
        Long2ObjectMap chunkMap = (Long2ObjectMap)levelMap.get(ChunkPos.m_151388_((BlockPos)pos));
        if (chunkMap == null) {
            return null;
        }
        return (CableTile)chunkMap.get(pos.m_121878_());
    }

    static void updateAdjacentCables(CableTile cable) {
        Long2ObjectMap<Long2ObjectMap<CableTile>> levelMap = loadedCables.get(cable.m_58904_());
        if (levelMap == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos adjPos = cable.m_58899_().m_121945_(direction);
            CableTile adjCable = CableNet.getCableAt(levelMap, adjPos);
            if (adjCable == null || adjCable.net == null) continue;
            adjCable.net.cableList.forEach(c -> {
                c.net = null;
            });
        }
    }

    static void calculateNetwork(CableTile cable) {
        Long2ObjectMap<Long2ObjectMap<CableTile>> levelMap = Objects.requireNonNull(loadedCables.get(cable.m_58904_()), "No level map?");
        LinkedHashSet<CableTile> cables = new LinkedHashSet<CableTile>();
        ArrayDeque<CableTile> queue = new ArrayDeque<CableTile>();
        cables.add(cable);
        queue.add(cable);
        while (!queue.isEmpty()) {
            CableTile cur = (CableTile)queue.pop();
            for (Direction direction : Direction.values()) {
                BlockPos adjPos = cur.m_58899_().m_121945_(direction);
                CableTile adjCable = CableNet.getCableAt(levelMap, adjPos);
                if (adjCable == null || !cables.add(adjCable)) continue;
                queue.add(adjCable);
            }
        }
        MutableBoolean insertionGuard = new MutableBoolean();
        CableNet net = new CableNet(new ArrayList<CableTile>(cables));
        for (CableTile tile : net.cableList) {
            tile.net = net;
            tile.netInsertionGuard = insertionGuard;
        }
    }

    CableNet(List<CableTile> cableList) {
        this.cableList = cableList;
    }

    public static void removeChunk(Level level, ChunkAccess chunk) {
        Long2ObjectMap<Long2ObjectMap<CableTile>> levelMap = loadedCables.get(level);
        if (levelMap == null) {
            return;
        }
        Long2ObjectMap chunkMap = (Long2ObjectMap)levelMap.remove(chunk.m_7697_().m_45588_());
        if (chunkMap == null) {
            return;
        }
        if (levelMap.isEmpty()) {
            loadedCables.remove(level);
        }
        for (CableTile cable : chunkMap.values()) {
            cable.net = null;
        }
        for (CableTile cable : chunkMap.values()) {
            CableNet.updateAdjacentCables(cable);
        }
    }
}

