/*
 * Decompiled with CFR 0.152.
 */
package dev.thestaticvoid.capejs;

import dev.latvian.mods.kubejs.event.EventJS;
import dev.thestaticvoid.capejs.CapeJS;
import dev.thestaticvoid.capejs.kubejs.AddCapeEventJS;
import dev.thestaticvoid.capejs.kubejs.CapeJSEvents;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;

public class CapeRegistry {
    private static final HashMap<UUID, ResourceLocation> CUSTOM_CAPE_MAP = new HashMap();
    private static final ResourceLocation DEV_CAPE = new ResourceLocation("capejs", CapeRegistry.locationString("dev_cape"));

    public static void initialize() {
        CapeJS.LOGGER.info("Registering custom capes for: capejs");
        CapeRegistry.addToCapeMap("8c641065-dba3-41f3-864f-edea4ddfc8bb", DEV_CAPE);
        CapeJSEvents.ADD_CAPE.post((EventJS)new AddCapeEventJS());
    }

    private static String locationString(String type) {
        return "textures/capes/" + type + ".png";
    }

    public static ResourceLocation createCapeResource(String type) {
        String textureLocation = CapeRegistry.locationString(type);
        if (type.equals("dev_cape")) {
            throw new IllegalArgumentException("dev_cape is reserved for mod author!");
        }
        if (!ResourceLocation.m_135830_((String)textureLocation)) {
            throw new IllegalArgumentException(type + ".png is not found in capejs/textures/capes/");
        }
        return new ResourceLocation("capejs", textureLocation);
    }

    public static void addToCapeMap(String uuid, ResourceLocation identifier) {
        if (!CUSTOM_CAPE_MAP.containsKey(UUID.fromString(uuid))) {
            CapeJS.LOGGER.info("Adding custom cape for: " + uuid + ", at: " + identifier);
            CUSTOM_CAPE_MAP.put(UUID.fromString(uuid), identifier);
        } else {
            CapeJS.LOGGER.info("Attempted to add cape for existing UUID: " + uuid);
        }
    }

    public static boolean mapContainsPlayer(AbstractClientPlayer player) {
        return CUSTOM_CAPE_MAP.containsKey(player.m_36316_().getId());
    }

    public static ResourceLocation getResourceByPlayer(AbstractClientPlayer player) {
        UUID uuid = player.m_36316_().getId();
        if (CUSTOM_CAPE_MAP.containsKey(uuid)) {
            return CUSTOM_CAPE_MAP.get(uuid);
        }
        return null;
    }
}

