/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.entity.condition.Condition;
import corgitaco.corgilib.entity.condition.ConditionContext;
import corgitaco.corgilib.serialization.codec.CodecUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class BiomeCondition
implements Condition {
    public static final Codec<BiomeCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtil.BIOME_CODEC.listOf().fieldOf("biome_is").forGetter(biomeCondition -> new ArrayList<ResourceKey<Biome>>(biomeCondition.biomes))).apply((Applicative)builder, BiomeCondition::new));
    private final Set<ResourceKey<Biome>> biomes;

    public BiomeCondition(Collection<ResourceKey<Biome>> biomes) {
        this.biomes = new ObjectOpenHashSet(biomes);
    }

    @Override
    public boolean passes(ConditionContext conditionContext) {
        Optional biomeKey = conditionContext.world().m_204166_(conditionContext.entity().m_20183_()).m_203543_();
        return biomeKey.isPresent() && this.biomes.contains(biomeKey.get());
    }

    @Override
    public Codec<? extends Condition> codec() {
        return CODEC;
    }
}

