/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.EcosphericalExpansion.api.biome.features.trunk_placers;

import com.Apothic0n.EcosphericalExpansion.api.biome.features.trunk_placers.EcoTrunkPlacerType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class GiantBranchingTrunkPlacer
extends TrunkPlacer {
    private static final Codec<UniformInt> BRANCH_START_CODEC = ExtraCodecs.m_264370_((Codec)UniformInt.f_146614_, uniformInt -> {
        if (uniformInt.m_142737_() - uniformInt.m_142739_() < 1) {
            return DataResult.error(() -> "Need at least 2 blocks variation for the branch starts to fit both branches");
        }
        return DataResult.success((Object)uniformInt);
    });
    public static final Codec<GiantBranchingTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> GiantBranchingTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.m_146545_((int)1, (int)12).fieldOf("amount_of_branches").forGetter(giantBranchingTrunkPlacer -> giantBranchingTrunkPlacer.amountOfBranches), (App)IntProvider.m_146545_((int)1, (int)3).fieldOf("branch_count").forGetter(giantBranchingTrunkPlacer -> giantBranchingTrunkPlacer.branchCount), (App)IntProvider.m_146545_((int)2, (int)16).fieldOf("branch_horizontal_length").forGetter(giantBranchingTrunkPlacer -> giantBranchingTrunkPlacer.branchHorizontalLength), (App)IntProvider.m_272161_((int)-48, (int)0, BRANCH_START_CODEC).fieldOf("branch_start_offset_from_top").forGetter(giantBranchingTrunkPlacer -> giantBranchingTrunkPlacer.branchStartOffsetFromTop), (App)IntProvider.m_146545_((int)-48, (int)48).fieldOf("branch_end_height").forGetter(giantBranchingTrunkPlacer -> giantBranchingTrunkPlacer.branchEndHeight))).apply((Applicative)instance, GiantBranchingTrunkPlacer::new));
    private final IntProvider amountOfBranches;
    private final IntProvider branchCount;
    private final IntProvider branchHorizontalLength;
    private final UniformInt branchStartOffsetFromTop;
    private final UniformInt secondBranchStartOffsetFromTop;
    private final IntProvider branchEndHeight;

    public GiantBranchingTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, IntProvider amountOfBranches, IntProvider branchCount, IntProvider branchHorizontalLength, UniformInt branchStartOffsetFromTop, IntProvider branchEndHeight) {
        super(baseHeight, heightRandA, heightRandB);
        this.amountOfBranches = branchCount;
        this.branchCount = branchCount;
        this.branchHorizontalLength = branchHorizontalLength;
        this.branchStartOffsetFromTop = branchStartOffsetFromTop;
        this.secondBranchStartOffsetFromTop = UniformInt.m_146622_((int)branchStartOffsetFromTop.m_142739_(), (int)(branchStartOffsetFromTop.m_142737_() - 1));
        this.branchEndHeight = branchEndHeight;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)EcoTrunkPlacerType.GIANT_BRANCHING_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        int m;
        int k;
        GiantBranchingTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_6625_(2), (TreeConfiguration)config);
        int i = Math.max(0, (freeTreeHeight *= 2) - 1 + this.branchStartOffsetFromTop.m_214085_(random));
        int j = Math.max(0, freeTreeHeight - 1 + this.secondBranchStartOffsetFromTop.m_214085_(random));
        if (j >= i) {
            ++j;
        }
        boolean bl = (k = this.branchCount.m_214085_(random)) == 3;
        boolean bl2 = k >= 2;
        boolean bl3 = bl2;
        int l = bl ? freeTreeHeight : (bl2 ? Math.max(i, j) + 1 : i + 1);
        for (m = 0; m <= 4; ++m) {
            this.m_226187_(level, blockSetter, random, pos.m_6625_(m), config);
            this.m_226187_(level, blockSetter, random, pos.m_6625_(m).m_122012_(), config);
            this.m_226187_(level, blockSetter, random, pos.m_6625_(m).m_122029_(), config);
            this.m_226187_(level, blockSetter, random, pos.m_6625_(m).m_122012_().m_122029_(), config);
        }
        for (m = 0; m < l; ++m) {
            this.m_226187_(level, blockSetter, random, pos.m_6630_(m), config);
            this.m_226187_(level, blockSetter, random, pos.m_6630_(m).m_122012_(), config);
            this.m_226187_(level, blockSetter, random, pos.m_6630_(m).m_122029_(), config);
            this.m_226187_(level, blockSetter, random, pos.m_6630_(m).m_122012_().m_122029_(), config);
        }
        ArrayList<FoliagePlacer.FoliageAttachment> list = new ArrayList<FoliagePlacer.FoliageAttachment>();
        list.add(new FoliagePlacer.FoliageAttachment(pos.m_6630_(l), 0, false));
        int amountOfBranches = this.amountOfBranches.m_214085_(random);
        int branchCount = this.branchCount.m_214085_(random);
        for (int b = 1; b <= amountOfBranches; ++b) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
            Function<BlockState, BlockState> function = blockState -> (BlockState)blockState.m_263224_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
            int randomNumber = (int)(Math.random() * (double)(-this.branchStartOffsetFromTop.m_214085_(random)) + 1.0);
            list.add(this.generateBranch(level, blockSetter, random, freeTreeHeight, pos.m_6625_(randomNumber), config, function, direction, i, i < l - 1, mutableBlockPos));
            if (branchCount > 1) {
                list.add(this.generateBranch(level, blockSetter, random, freeTreeHeight, pos.m_6625_(randomNumber), config, function, direction.m_122427_(), j, j < l - 1, mutableBlockPos));
            }
            if (branchCount <= 2) continue;
            list.add(this.generateBranch(level, blockSetter, random, freeTreeHeight, pos.m_6625_(randomNumber), config, function, direction.m_122428_(), j, j < l - 1, mutableBlockPos));
        }
        return list;
    }

    private FoliagePlacer.FoliageAttachment generateBranch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> posSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config, Function<BlockState, BlockState> propertySetter, Direction direction, int secondBranchStartOffsetFromTop, boolean bl, BlockPos.MutableBlockPos mutableBlockPos) {
        int m;
        mutableBlockPos.m_122190_((Vec3i)pos).m_122175_(Direction.UP, secondBranchStartOffsetFromTop);
        int i = secondBranchStartOffsetFromTop + this.branchEndHeight.m_214085_(random);
        boolean bl2 = bl || i < secondBranchStartOffsetFromTop;
        int j = this.branchHorizontalLength.m_214085_(random) + (bl2 ? 1 : 0);
        BlockPos blockPos = pos.m_5484_(direction, j).m_6630_(i);
        int k = bl2 ? 2 : 1;
        for (int l = 0; l < k; ++l) {
            this.m_226175_(level, posSetter, random, (BlockPos)mutableBlockPos.m_122173_(direction), config, propertySetter);
        }
        Direction direction2 = blockPos.m_123342_() > mutableBlockPos.m_123342_() ? Direction.UP : Direction.DOWN;
        Direction direction3 = direction2;
        while ((m = mutableBlockPos.m_123333_((Vec3i)blockPos)) != 0) {
            float f = (float)Math.abs(blockPos.m_123342_() - mutableBlockPos.m_123342_()) / (float)m;
            boolean bl3 = random.m_188501_() < f;
            mutableBlockPos.m_122173_(bl3 ? direction2 : direction);
            this.m_226175_(level, posSetter, random, (BlockPos)mutableBlockPos, config, bl3 ? Function.identity() : propertySetter);
            this.m_226175_(level, posSetter, random, mutableBlockPos.m_122012_(), config, bl3 ? Function.identity() : propertySetter);
            this.m_226175_(level, posSetter, random, mutableBlockPos.m_122029_(), config, bl3 ? Function.identity() : propertySetter);
            this.m_226175_(level, posSetter, random, mutableBlockPos.m_122012_().m_122029_(), config, bl3 ? Function.identity() : propertySetter);
        }
        return new FoliagePlacer.FoliageAttachment(blockPos.m_7494_(), 0, false);
    }
}

