/*
 * Decompiled with CFR 0.152.
 */
package blueduck.vounierns_turrets.entity;

import blueduck.vounierns_turrets.entity.AbstractTurret;
import blueduck.vounierns_turrets.registry.TurretEntities;
import blueduck.vounierns_turrets.registry.TurretSounds;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SniperTurret
extends AbstractTurret
implements RangedAttackMob,
GeoEntity {
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SniperTurret(EntityType<? extends AbstractGolem> p_27508_, Level p_27509_) {
        super(p_27508_, p_27509_);
        this.tier = this.getTier();
    }

    public void m_6504_(LivingEntity p_29912_, float p_29913_) {
        Arrow snowball = new Arrow(this.m_9236_(), (LivingEntity)this);
        if (this.tier == 3) {
            snowball.m_146884_(snowball.m_20318_(1.0f).m_82520_(0.0, -0.7, 0.0));
        }
        double d0 = p_29912_.m_20188_() - (double)1.1f;
        double d1 = p_29912_.m_20185_() - this.m_20185_();
        double d2 = d0 - snowball.m_20186_();
        double d3 = p_29912_.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        this.shootAccurate(d1, d2 + d4, d3, 1.6f, 12.0f, snowball);
        this.m_9236_().m_7967_((Entity)snowball);
        this.m_6674_(InteractionHand.MAIN_HAND);
        this.m_5496_((SoundEvent)TurretSounds.SNIPER_TURRET_SHOOT.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public void shootAccurate(double p_37266_, double p_37267_, double p_37268_, float p_37269_, float p_37270_, Arrow arrow) {
        Vec3 vec3 = new Vec3(p_37266_, p_37267_, p_37268_).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.005 * (double)p_37270_), this.f_19796_.m_216328_(0.0, 0.005 * (double)p_37270_), this.f_19796_.m_216328_(0.0, 0.005 * (double)p_37270_)).m_82490_((double)p_37269_);
        arrow.m_20256_(vec3);
        double d0 = vec3.m_165924_();
        arrow.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        arrow.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        arrow.f_19859_ = arrow.m_146908_();
        arrow.f_19860_ = arrow.m_146909_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, this.getTier() >= 3 ? 35 : (this.getTier() == 2 ? 45 : 60), 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, p_29932_ -> p_29932_ instanceof Enemy));
    }

    public static AttributeSupplier.Builder createT1Attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    public static AttributeSupplier.Builder createT2Attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 36.0);
    }

    public static AttributeSupplier.Builder createT3Attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22278_, 0.2).m_22268_(Attributes.f_22277_, 36.0);
    }

    protected float m_6431_(Pose p_29917_, EntityDimensions p_29918_) {
        return this.tier == 3 ? 0.325f : 1.2f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.tier == 3 ? (SoundEvent)TurretSounds.TURRET_PROPELLER.get() : (SoundEvent)TurretSounds.TURRET_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_29929_) {
        return (SoundEvent)TurretSounds.TURRET_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TurretSounds.TURRET_DEATH.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState event) {
        event.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState attackPredicate(AnimationState event) {
        if (this.f_20911_ && this.f_20913_ != -1) {
            event.getController().setAnimation(FIRE);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
    }

    public int getTier() {
        EntityType type = this.m_6095_();
        if (type.equals(TurretEntities.SNIPER_TURRET_T1.get())) {
            return 1;
        }
        if (type.equals(TurretEntities.SNIPER_TURRET_T2.get())) {
            return 2;
        }
        if (type.equals(TurretEntities.SNIPER_TURRET_T3.get())) {
            return 3;
        }
        return 0;
    }

    @Override
    public void m_8107_() {
        Vec3 vec3 = this.m_20184_();
        if (this.tier >= 3 && !this.m_20096_()) {
            if (vec3.f_82480_ < 0.0) {
                this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
            }
            boolean hover = false;
            for (int i = 0; i < 3; ++i) {
                if (this.m_9236_().m_8055_(this.m_20097_().m_6625_(i)).m_60734_().equals(Blocks.f_50016_)) continue;
                hover = true;
            }
            if (hover) {
                this.m_20256_(vec3.m_82520_(0.0, 0.1, 0.0));
            }
        }
        this.updateSwingTimeTurret();
        super.m_8107_();
    }

    protected void updateSwingTimeTurret() {
        int i = 50;
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= i) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
        this.f_20921_ = (float)this.f_20913_ / (float)i;
    }
}

