/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.traits;

import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.integration.energy.EnergyCompatUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class KineticModifier
extends NoLevelsModifier
implements MeleeHitModifierHook,
BlockBreakModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_HIT, ModifierHooks.BLOCK_BREAK);
    }

    public void failedMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageAttempted) {
        ServerPlayer sp = (ServerPlayer)context.getPlayerAttacker();
        if (sp != null) {
            this.chargeInventoryItem(sp);
        }
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        ServerPlayer sp = (ServerPlayer)context.getPlayerAttacker();
        if (sp != null) {
            this.chargeInventoryItem(sp);
        }
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        ServerPlayer sp = context.getPlayer();
        if (sp != null && !sp.m_9236_().f_46443_) {
            this.chargeInventoryItem(sp);
        }
    }

    private void chargeInventoryItem(ServerPlayer sp) {
        Optional itemHandlerCap = sp.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (!this.chargeHandler(itemHandlerCap) && Mekanism.hooks.CuriosLoaded) {
            this.chargeHandler(CuriosIntegration.getCuriosInventory((LivingEntity)sp));
        }
    }

    private boolean chargeHandler(Optional<? extends IItemHandler> itemHandlerCap) {
        if (itemHandlerCap.isPresent()) {
            IItemHandler itemHandler = itemHandlerCap.get();
            int slots = itemHandler.getSlots();
            for (int slot = 0; slot < slots; ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (stack.m_41619_() || !this.provideEnergy(EnergyCompatUtils.getStrictEnergyHandler((ItemStack)stack))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean provideEnergy(@Nullable IStrictEnergyHandler energyHandler) {
        if (energyHandler == null) {
            return false;
        }
        FloatingLong energyToGive = FloatingLong.create((long)20L);
        energyHandler.insertEnergy(energyToGive, Action.EXECUTE);
        return true;
    }
}

