/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.tool;

import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.stats.ToolType;
import tcintegrations.data.integration.ModIntegration;
import tcintegrations.util.ResourceLocationHelper;

public class TwilitModifier
extends Modifier
implements ConditionalStatModifierHook,
BreakSpeedModifierHook,
MeleeDamageModifierHook,
TooltipModifierHook {
    private static final Component MINING_SPEED = Component.m_237115_((String)Util.m_137492_((String)"modifier", (ResourceLocation)ResourceLocationHelper.resource("twilit.mining_speed")));
    private static final Component VELOCITY = Component.m_237115_((String)Util.m_137492_((String)"modifier", (ResourceLocation)ResourceLocationHelper.resource("twilit.velocity")));
    private static final Component DAMAGE = Component.m_237115_((String)Util.m_137492_((String)"modifier", (ResourceLocation)ResourceLocationHelper.resource("twilit.damage")));
    private static final float VELOCITY_MULTIPLIER = 1.1f;
    private static final float MINING_SPEED_MULTIPLIER = 2.0f;
    private static final float MELEE_DAMAGE_MULTIPLIER = 1.5f;

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.CONDITIONAL_STAT, ModifierHooks.BREAK_SPEED, ModifierHooks.MELEE_DAMAGE, ModifierHooks.TOOLTIP});
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.VELOCITY) {
            Player player;
            Player player2 = player = entity instanceof Player ? (Player)entity : null;
            if (player != null && !player.m_9236_().f_46443_) {
                return TwilitModifier.getVelocityBonus(player, baseValue);
            }
        }
        return baseValue;
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        Player player = context.getPlayerAttacker();
        if (player != null && !player.m_9236_().f_46443_ && !TwilitModifier.isTwilightForest(player)) {
            return TwilitModifier.getMeleeDamageBonus(player, damage);
        }
        return damage;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        if (player != null && key == TooltipKey.SHIFT) {
            Item toolItem = tool.getItem();
            if (!TwilitModifier.isTwilightForest(player) && RegistryHelper.contains((TagKey)ToolType.MELEE.getTag(), (Item)toolItem)) {
                TooltipModifierHook.addPercentBoost((Modifier)this, (Component)DAMAGE, (double)1.5, tooltip);
            }
            if (TwilitModifier.isTwilightForest(player)) {
                if (RegistryHelper.contains((TagKey)ToolType.HARVEST.getTag(), (Item)toolItem)) {
                    TooltipModifierHook.addPercentBoost((Modifier)this, (Component)MINING_SPEED, (double)2.0, tooltip);
                }
                if (RegistryHelper.contains((TagKey)ToolType.RANGED.getTag(), (Item)toolItem)) {
                    TooltipModifierHook.addPercentBoost((Modifier)this, (Component)VELOCITY, (double)1.1f, tooltip);
                }
            }
        }
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction direction, boolean isEffective, float miningSpeedModifier) {
        if (isEffective && TwilitModifier.isTwilightForest(event.getEntity())) {
            event.setNewSpeed(TwilitModifier.getMiningSpeedBonus(event.getEntity(), miningSpeedModifier));
        }
    }

    private static float getVelocityBonus(Player player, float baseValue) {
        if (TwilitModifier.isTwilightForest(player)) {
            return baseValue * 1.1f;
        }
        return baseValue;
    }

    private static float getMiningSpeedBonus(Player player, float miningSpeedModifier) {
        if (TwilitModifier.isTwilightForest(player)) {
            return miningSpeedModifier * 2.0f;
        }
        return miningSpeedModifier;
    }

    private static float getMeleeDamageBonus(Player player, float damage) {
        if (!TwilitModifier.isTwilightForest(player)) {
            return damage * 1.5f;
        }
        return damage;
    }

    private static boolean isTwilightForest(Player player) {
        return player.m_9236_().m_46472_().m_135782_().toString().contains(ModIntegration.twilightLoc("twilight_forest").toString());
    }
}

