/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.tool;

import com.teammetallurgy.aquaculture.init.AquaBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;
import tcintegrations.util.ResourceLocationHelper;

public class SirenModifier
extends NoLevelsModifier
implements BreakSpeedModifierHook,
TooltipModifierHook,
BlockInteractionModifierHook,
MeleeDamageModifierHook {
    private static final float ATTACK_BONUS = 1.5f;
    private static final float SPEED_BONUS = 5.0f;
    private static final Component MINING_SPEED = Component.m_237115_((String)net.minecraft.Util.m_137492_((String)"modifier", (ResourceLocation)ResourceLocationHelper.resource("siren.mining_speed")));

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.BREAK_SPEED, ModifierHooks.TOOLTIP, ModifierHooks.BLOCK_INTERACT, ModifierHooks.MELEE_DAMAGE});
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        if (tool.hasTag(TinkerTags.Items.MELEE) && context.getAttacker().m_204029_(FluidTags.f_13131_) && !tool.isBroken()) {
            return damage * 1.5f;
        }
        return damage;
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getEntity();
        if (player != null && !player.m_9236_().f_46443_ && !tool.isBroken()) {
            boolean isSubmerged;
            ServerPlayer sp = (ServerPlayer)player;
            boolean bl = isSubmerged = sp.m_5842_() && sp.m_20069_() && sp.m_20071_();
            if (isEffective && tool.hasTag(TinkerTags.Items.HARVEST) && isSubmerged) {
                event.setNewSpeed(event.getNewSpeed() + 5.0f * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED) * miningSpeedModifier);
            }
        }
    }

    public InteractionResult afterBlockUse(IToolStackView tool, ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        BlockPos pos;
        BlockState blockState;
        Player player = context.m_43723_();
        Level mcLevel = context.m_43725_();
        if (player != null && !mcLevel.f_46443_ && !tool.isBroken() && (blockState = mcLevel.m_8055_(pos = context.m_8083_()).getToolModifiedState(context, ToolActions.HOE_TILL, false)) != null && context.m_43719_() != Direction.DOWN && mcLevel.m_46859_(pos.m_7494_()) && blockState == Blocks.f_50093_.m_49966_()) {
            mcLevel.m_7731_(pos, ((Block)AquaBlocks.FARMLAND.get()).m_49966_(), 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float bonus = 0.0f;
        if (tool.hasTag(TinkerTags.Items.MELEE)) {
            if (player != null && tooltipKey == TooltipKey.SHIFT && player.m_204029_(FluidTags.f_13131_)) {
                float damage = ToolAttackUtil.getAttributeAttackDamage((IToolStackView)tool, (LivingEntity)player, (EquipmentSlot)Util.getSlotType((InteractionHand)player.m_7655_()));
                bonus = damage * 1.5f;
            }
            if (bonus > 0.0f) {
                TooltipModifierHook.addDamageBoost((IToolStackView)tool, (Modifier)modifier.getModifier(), (float)bonus, tooltip);
            }
        }
        if (tool.hasTag(TinkerTags.Items.HARVEST)) {
            if (player != null && tooltipKey == TooltipKey.SHIFT && player.m_204029_(FluidTags.f_13131_)) {
                bonus = 5.0f;
            }
            if (bonus > 0.0f) {
                TooltipModifierHook.addFlatBoost((Modifier)modifier.getModifier(), (Component)MINING_SPEED, (double)(bonus * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED)), tooltip);
            }
        }
    }
}

