/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.armor;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ArmorWalkModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class RoadrunnerModifier
extends Modifier
implements ArmorWalkModifierHook,
EquipmentChangeModifierHook,
TooltipModifierHook {
    private static final UUID ATTRIBUTE_BONUS = UUID.fromString("cd653c21-b0a3-4542-a81e-e575e2b95c7c");
    private static final float SPEED_FACTOR = 0.04f;

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.BOOT_WALK, ModifierHooks.EQUIPMENT_CHANGE, ModifierHooks.TOOLTIP);
    }

    private static BlockPos getOnPosition(LivingEntity living) {
        Vec3 position = living.m_20182_();
        int x = Mth.m_14107_((double)position.f_82479_);
        int y = Mth.m_14107_((double)(position.f_82480_ - (double)0.2f));
        int z = Mth.m_14107_((double)position.f_82481_);
        BlockPos pos = new BlockPos(x, y, z);
        if (living.m_9236_().m_46859_(pos)) {
            BlockPos below = pos.m_7495_();
            BlockState blockstate = living.m_9236_().m_8055_(below);
            if (blockstate.collisionExtendsVertically((BlockGetter)living.m_9236_(), below, (Entity)living)) {
                return below;
            }
        }
        return pos;
    }

    public void onWalk(IToolStackView tool, ModifierEntry modifier, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        if (tool.isBroken() || !living.m_20096_() || living.m_9236_().f_46443_) {
            return;
        }
        AttributeInstance attribute = living.m_21051_(Attributes.f_22279_);
        if (attribute == null) {
            return;
        }
        BlockPos belowPos = RoadrunnerModifier.getOnPosition(living);
        BlockState below = living.m_9236_().m_8055_(belowPos);
        if (below.m_60795_()) {
            return;
        }
        if (attribute.m_22111_(ATTRIBUTE_BONUS) != null) {
            attribute.m_22120_(ATTRIBUTE_BONUS);
        }
        if (!living.m_21255_() && below.m_204336_(BlockTags.f_13029_)) {
            RandomSource rand = living.m_217043_();
            float boost = modifier.getEffectiveLevel() * 0.04f;
            attribute.m_22118_(new AttributeModifier(ATTRIBUTE_BONUS, "tcintegrations.modifier.roadrunner", (double)boost, AttributeModifier.Operation.ADDITION));
            if (rand.m_188501_() < 0.04f) {
                ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)1, (LivingEntity)living, (EquipmentSlot)EquipmentSlot.FEET);
            }
            Vec3 motion = living.m_20184_();
            if (living.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)living.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123783_, living.m_20185_() + (rand.m_188500_() - 0.5) * (double)living.m_20205_(), living.m_20186_() + 0.1, living.m_20189_() + (rand.m_188500_() - 0.5) * (double)living.m_20205_(), 0, motion.f_82479_ * -0.2, 0.1, motion.f_82481_ * -0.2, 1.0);
            }
            living.m_9236_().m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_12332_, living.m_5720_(), rand.m_188501_() * 0.4f + rand.m_188501_() > 0.9f ? 0.6f : 0.0f, 0.6f + rand.m_188501_() * 0.4f);
        }
    }

    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        AttributeInstance attribute;
        IToolStackView newTool;
        LivingEntity livingEntity = context.getEntity();
        if (!livingEntity.m_9236_().f_46443_ && context.getChangedSlot() == EquipmentSlot.FEET && ((newTool = context.getReplacementTool()) == null || newTool.isBroken() || (float)newTool.getModifierLevel((Modifier)this) != modifier.getEffectiveLevel()) && (attribute = livingEntity.m_21051_(Attributes.f_22279_)) != null && attribute.m_22111_(ATTRIBUTE_BONUS) != null) {
            attribute.m_22120_(ATTRIBUTE_BONUS);
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (player == null || tooltipKey == TooltipKey.SHIFT || !player.m_21255_() && player.m_9236_().m_8055_(RoadrunnerModifier.getOnPosition((LivingEntity)player)).m_204336_(BlockTags.f_13029_)) {
            TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)this.getDisplayName(), (double)(modifier.getEffectiveLevel() * 0.04f), tooltip);
        }
    }
}

