/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.armor;

import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ArmorWalkModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class MosquitoModifier
extends Modifier
implements ArmorWalkModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.BOOT_WALK);
    }

    public Component getDisplayName(int level) {
        return super.getDisplayName();
    }

    public void onWalk(IToolStackView tool, ModifierEntry modifier, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        float level;
        if ((living.f_19797_ & 1) == 0 && !tool.isBroken() && (level = modifier.getEffectiveLevel()) > 0.0f) {
            MosquitoModifier.applyAnnoyance(living, level);
        }
    }

    public static void applyAnnoyance(LivingEntity living, float level) {
        double x = living.m_20185_();
        double y = living.m_20186_();
        double z = living.m_20189_();
        float range = 3.0f + level;
        List entities = living.m_9236_().m_45976_(LivingEntity.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
        if (!entities.isEmpty() && living.f_19797_ % 100 == 0) {
            living.m_5496_((SoundEvent)AMSoundRegistry.MOSQUITO_LOOP.get(), 1.0f, 1.0f);
        }
        for (LivingEntity livingEntity : entities) {
            if (livingEntity.equals((Object)living) || living.f_19797_ % 20 != 0) continue;
            for (int i = 0; i < 3; ++i) {
                livingEntity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123784_, livingEntity.m_20208_(1.0), livingEntity.m_20187_(), livingEntity.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        }
    }
}

